/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class GeoTestingOps {
    public static List<Point3D_F64> createList3_F64(int N) {
        ArrayList<Point3D_F64> ret = new ArrayList<Point3D_F64>();
        for (int i = 0; i < N; ++i) {
            ret.add(new Point3D_F64());
        }
        return ret;
    }

    public static List<Point3D_F64> randomPoints_F64(double minX, double maxX, double minY, double maxY, double minZ, double maxZ, int num, Random rand) {
        ArrayList<Point3D_F64> ret = new ArrayList<Point3D_F64>();
        for (int i = 0; i < num; ++i) {
            double x = rand.nextDouble() * (maxX - minX) + minX;
            double y = rand.nextDouble() * (maxY - minY) + minY;
            double z = rand.nextDouble() * (maxZ - minZ) + minZ;
            ret.add(new Point3D_F64(x, y, z));
        }
        return ret;
    }

    public static List<Point2D_F64> randomPoints_F64(double minX, double maxX, double minY, double maxY, int num, Random rand) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (int i = 0; i < num; ++i) {
            double x = rand.nextDouble() * (maxX - minX) + minX;
            double y = rand.nextDouble() * (maxY - minY) + minY;
            ret.add(new Point2D_F64(x, y));
        }
        return ret;
    }

    public static double residualError(double[] residuals) {
        double total = 0.0;
        for (double d : residuals) {
            total += d * d;
        }
        return total * 0.5;
    }
}

