/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.geo.DecomposeEssential;
import boofcv.alg.geo.DecomposeHomography;
import boofcv.alg.geo.h.HomographyInducedStereo2Line;
import boofcv.alg.geo.h.HomographyInducedStereo3Pts;
import boofcv.alg.geo.h.HomographyInducedStereoLinePt;
import boofcv.alg.geo.trifocal.TrifocalExtractEpipoles;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.Tuple2;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public class MultiViewOps {
    public static TrifocalTensor createTrifocal(DMatrixRMaj P2, DMatrixRMaj P3, TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        for (int col = 0; col < 3; ++col) {
            DMatrixRMaj T = ret.getT(col);
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                double a_left = P2.get(i, col);
                double a_right = P2.get(i, 3);
                for (int j = 0; j < 3; ++j) {
                    T.data[index++] = a_left * P3.get(j, 3) - a_right * P3.get(j, col);
                }
            }
        }
        return ret;
    }

    public static TrifocalTensor createTrifocal(Se3_F64 P2, Se3_F64 P3, TrifocalTensor ret) {
        if (ret == null) {
            ret = new TrifocalTensor();
        }
        DMatrixRMaj R2 = P2.getR();
        DMatrixRMaj R3 = P3.getR();
        Vector3D_F64 T2 = P2.getT();
        Vector3D_F64 T3 = P3.getT();
        for (int col = 0; col < 3; ++col) {
            DMatrixRMaj T = ret.getT(col);
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                double a_left = R2.unsafe_get(i, col);
                double a_right = T2.getIndex(i);
                for (int j = 0; j < 3; ++j) {
                    T.data[index++] = a_left * T3.getIndex(j) - a_right * R3.unsafe_get(j, col);
                }
            }
        }
        return ret;
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Vector3D_F64 l1, Vector3D_F64 l2, Vector3D_F64 l3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        double x = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)tensor.T1, (GeoTuple3D_F64)l3);
        double y = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)tensor.T2, (GeoTuple3D_F64)l3);
        double z = GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)tensor.T3, (GeoTuple3D_F64)l3);
        GeometryMath_F64.cross((GeoTuple3D_F64)new Vector3D_F64(x, y, z), (GeoTuple3D_F64)l1, (GeoTuple3D_F64)ret);
        return ret;
    }

    public static double constraint(TrifocalTensor tensor, Point2D_F64 p1, Vector3D_F64 l2, Vector3D_F64 l3) {
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)tensor.T3, (DMatrixD1)sum, (DMatrixD1)sum);
        return GeometryMath_F64.innerProd((GeoTuple3D_F64)l2, (DMatrixRMaj)sum, (GeoTuple3D_F64)l3);
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Point2D_F64 p1, Vector3D_F64 l2, Point2D_F64 p3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)tensor.T3, (DMatrixD1)sum, (DMatrixD1)sum);
        Vector3D_F64 tempV = new Vector3D_F64();
        GeometryMath_F64.multTran((DMatrixRMaj)sum, (GeoTuple3D_F64)l2, (GeoTuple3D_F64)tempV);
        GeometryMath_F64.cross((GeoTuple3D_F64)tempV, (GeoTuple3D_F64)new Vector3D_F64(p3.x, p3.y, 1.0), (GeoTuple3D_F64)ret);
        return ret;
    }

    public static Vector3D_F64 constraint(TrifocalTensor tensor, Point2D_F64 p1, Point2D_F64 p2, Vector3D_F64 l3, Vector3D_F64 ret) {
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)tensor.T3, (DMatrixD1)sum, (DMatrixD1)sum);
        DMatrixRMaj cross2 = GeometryMath_F64.crossMatrix((double)p2.x, (double)p2.y, (double)1.0, null);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)cross2, (DMatrix1Row)sum, (DMatrix1Row)temp);
        GeometryMath_F64.mult((DMatrixRMaj)temp, (GeoTuple3D_F64)l3, (GeoTuple3D_F64)ret);
        return ret;
    }

    public static DMatrixRMaj constraint(TrifocalTensor tensor, Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3, DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj sum = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.add((double)p1.x, (DMatrixD1)tensor.T1, (double)p1.y, (DMatrixD1)tensor.T2, (DMatrixD1)sum);
        CommonOps_DDRM.add((DMatrixD1)sum, (DMatrixD1)tensor.T3, (DMatrixD1)sum);
        DMatrixRMaj cross2 = GeometryMath_F64.crossMatrix((double)p2.x, (double)p2.y, (double)1.0, null);
        DMatrixRMaj cross3 = GeometryMath_F64.crossMatrix((double)p3.x, (double)p3.y, (double)1.0, null);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)cross2, (DMatrix1Row)sum, (DMatrix1Row)temp);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)cross3, (DMatrix1Row)ret);
        return ret;
    }

    public static double constraint(DMatrixRMaj F, Point2D_F64 p1, Point2D_F64 p2) {
        return GeometryMath_F64.innerProd((GeoTuple2D_F64)p2, (DMatrixRMaj)F, (GeoTuple2D_F64)p1);
    }

    public static Point2D_F64 constraintHomography(DMatrixRMaj H, Point2D_F64 p1, Point2D_F64 outputP2) {
        if (outputP2 == null) {
            outputP2 = new Point2D_F64();
        }
        GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple2D_F64)p1, (GeoTuple2D_F64)outputP2);
        return outputP2;
    }

    public static DMatrixRMaj inducedHomography13(TrifocalTensor tensor, Vector3D_F64 line2, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj T = tensor.T1;
        output.data[0] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[3] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[6] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        T = tensor.T2;
        output.data[1] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[4] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[7] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        T = tensor.T3;
        output.data[2] = T.data[0] * line2.x + T.data[3] * line2.y + T.data[6] * line2.z;
        output.data[5] = T.data[1] * line2.x + T.data[4] * line2.y + T.data[7] * line2.z;
        output.data[8] = T.data[2] * line2.x + T.data[5] * line2.y + T.data[8] * line2.z;
        return output;
    }

    public static DMatrixRMaj inducedHomography12(TrifocalTensor tensor, Vector3D_F64 line3, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(3, 3);
        }
        DMatrixRMaj T = tensor.T1;
        output.data[0] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[3] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[6] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        T = tensor.T2;
        output.data[1] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[4] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[7] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        T = tensor.T3;
        output.data[2] = T.data[0] * line3.x + T.data[1] * line3.y + T.data[2] * line3.z;
        output.data[5] = T.data[3] * line3.x + T.data[4] * line3.y + T.data[5] * line3.z;
        output.data[8] = T.data[6] * line3.x + T.data[7] * line3.y + T.data[8] * line3.z;
        return output;
    }

    public static DMatrixRMaj homographyStereo3Pts(DMatrixRMaj F, AssociatedPair p1, AssociatedPair p2, AssociatedPair p3) {
        HomographyInducedStereo3Pts alg = new HomographyInducedStereo3Pts();
        alg.setFundamental(F, null);
        if (!alg.process(p1, p2, p3)) {
            return null;
        }
        return alg.getHomography();
    }

    public static DMatrixRMaj homographyStereoLinePt(DMatrixRMaj F, PairLineNorm line, AssociatedPair point) {
        HomographyInducedStereoLinePt alg = new HomographyInducedStereoLinePt();
        alg.setFundamental(F, null);
        alg.process(line, point);
        return alg.getHomography();
    }

    public static DMatrixRMaj homographyStereo2Lines(DMatrixRMaj F, PairLineNorm line0, PairLineNorm line1) {
        HomographyInducedStereo2Line alg = new HomographyInducedStereo2Line();
        alg.setFundamental(F, null);
        if (!alg.process(line0, line1)) {
            return null;
        }
        return alg.getHomography();
    }

    public static void extractEpipoles(TrifocalTensor tensor, Point3D_F64 e2, Point3D_F64 e3) {
        TrifocalExtractEpipoles extract = new TrifocalExtractEpipoles();
        extract.process(tensor, e2, e3);
    }

    public static void extractFundamental(TrifocalTensor tensor, DMatrixRMaj F2, DMatrixRMaj F3) {
        Point3D_F64 e2 = new Point3D_F64();
        Point3D_F64 e3 = new Point3D_F64();
        MultiViewOps.extractEpipoles(tensor, e2, e3);
        Point3D_F64 temp0 = new Point3D_F64();
        Point3D_F64 column = new Point3D_F64();
        for (int i = 0; i < 3; ++i) {
            DMatrixRMaj T = tensor.getT(i);
            GeometryMath_F64.mult((DMatrixRMaj)T, (GeoTuple3D_F64)e3, (GeoTuple3D_F64)temp0);
            GeometryMath_F64.cross((GeoTuple3D_F64)e2, (GeoTuple3D_F64)temp0, (GeoTuple3D_F64)column);
            F2.set(0, i, column.x);
            F2.set(1, i, column.y);
            F2.set(2, i, column.z);
            GeometryMath_F64.multTran((DMatrixRMaj)T, (GeoTuple3D_F64)e2, (GeoTuple3D_F64)temp0);
            GeometryMath_F64.cross((GeoTuple3D_F64)e3, (GeoTuple3D_F64)temp0, (GeoTuple3D_F64)column);
            F3.set(0, i, column.x);
            F3.set(1, i, column.y);
            F3.set(2, i, column.z);
        }
    }

    public static void extractCameraMatrices(TrifocalTensor tensor, DMatrixRMaj P2, DMatrixRMaj P3) {
        int i;
        Point3D_F64 e2 = new Point3D_F64();
        Point3D_F64 e3 = new Point3D_F64();
        MultiViewOps.extractEpipoles(tensor, e2, e3);
        Point3D_F64 temp0 = new Point3D_F64();
        Point3D_F64 column = new Point3D_F64();
        DMatrixRMaj temp1 = new DMatrixRMaj(3, 3);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                temp1.set(i, j, e3.getIndex(i) * e3.getIndex(j));
            }
            temp1.set(i, i, temp1.get(i, i) - 1.0);
        }
        for (i = 0; i < 3; ++i) {
            DMatrixRMaj T = tensor.getT(i);
            GeometryMath_F64.mult((DMatrixRMaj)T, (GeoTuple3D_F64)e3, (GeoTuple3D_F64)column);
            P2.set(0, i, column.x);
            P2.set(1, i, column.y);
            P2.set(2, i, column.z);
            P2.set(i, 3, e2.getIndex(i));
            GeometryMath_F64.multTran((DMatrixRMaj)T, (GeoTuple3D_F64)e2, (GeoTuple3D_F64)temp0);
            GeometryMath_F64.mult((DMatrixRMaj)temp1, (GeoTuple3D_F64)temp0, (GeoTuple3D_F64)column);
            P3.set(0, i, column.x);
            P3.set(1, i, column.y);
            P3.set(2, i, column.z);
            P3.set(i, 3, e3.getIndex(i));
        }
    }

    public static DMatrixRMaj createEssential(DMatrixRMaj R, Vector3D_F64 T) {
        DMatrixRMaj E = new DMatrixRMaj(3, 3);
        DMatrixRMaj T_hat = GeometryMath_F64.crossMatrix((GeoTuple3D_F64)T, null);
        CommonOps_DDRM.mult((DMatrix1Row)T_hat, (DMatrix1Row)R, (DMatrix1Row)E);
        return E;
    }

    public static DMatrixRMaj createFundamental(DMatrixRMaj E, DMatrixRMaj K) {
        DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)K_inv);
        DMatrixRMaj F = new DMatrixRMaj(3, 3);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multTransA((DMatrix1Row)K_inv, (DMatrix1Row)E, (DMatrix1Row)temp);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)K_inv, (DMatrix1Row)F);
        return F;
    }

    public static DMatrixRMaj createFundamental(DMatrixRMaj E, DMatrixRMaj K1, DMatrixRMaj K2) {
        DMatrixRMaj K1_inv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)K1, (DMatrixRMaj)K1_inv);
        DMatrixRMaj K2_inv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)K2, (DMatrixRMaj)K2_inv);
        DMatrixRMaj F = new DMatrixRMaj(3, 3);
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multTransA((DMatrix1Row)K2_inv, (DMatrix1Row)E, (DMatrix1Row)temp);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)K1_inv, (DMatrix1Row)F);
        return F;
    }

    public static DMatrixRMaj createHomography(DMatrixRMaj R, Vector3D_F64 T, double d, Vector3D_F64 N) {
        DMatrixRMaj H = new DMatrixRMaj(3, 3);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)T, (GeoTuple3D_F64)N, (DMatrixRMaj)H);
        CommonOps_DDRM.divide((DMatrixD1)H, (double)d);
        CommonOps_DDRM.addEquals((DMatrixD1)H, (DMatrixD1)R);
        return H;
    }

    public static DMatrixRMaj createHomography(DMatrixRMaj R, Vector3D_F64 T, double d, Vector3D_F64 N, DMatrixRMaj K) {
        DMatrixRMaj temp = new DMatrixRMaj(3, 3);
        DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);
        DMatrixRMaj H = MultiViewOps.createHomography(R, T, d, N);
        CommonOps_DDRM.mult((DMatrix1Row)K, (DMatrix1Row)H, (DMatrix1Row)temp);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)K_inv);
        CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)K_inv, (DMatrix1Row)H);
        return H;
    }

    public static void extractEpipoles(DMatrixRMaj F, Point3D_F64 e1, Point3D_F64 e2) {
        SimpleMatrix f = SimpleMatrix.wrap((Matrix)F);
        SimpleSVD svd = f.svd();
        SimpleMatrix U = (SimpleMatrix)svd.getU();
        SimpleMatrix V = (SimpleMatrix)svd.getV();
        if (e2 != null) {
            e2.set(U.get(0, 2), U.get(1, 2), U.get(2, 2));
        }
        if (e1 != null) {
            e1.set(V.get(0, 2), V.get(1, 2), V.get(2, 2));
        }
    }

    public static DMatrixRMaj canonicalCamera(DMatrixRMaj F, Point3D_F64 e2, Vector3D_F64 v, double lambda) {
        DMatrixRMaj crossMatrix = new DMatrixRMaj(3, 3);
        GeometryMath_F64.crossMatrix((GeoTuple3D_F64)e2, (DMatrixRMaj)crossMatrix);
        DMatrixRMaj outer = new DMatrixRMaj(3, 3);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)e2, (GeoTuple3D_F64)v, (DMatrixRMaj)outer);
        DMatrixRMaj KR = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)crossMatrix, (DMatrix1Row)F, (DMatrix1Row)KR);
        CommonOps_DDRM.add((DMatrixD1)KR, (DMatrixD1)outer, (DMatrixD1)KR);
        DMatrixRMaj P = new DMatrixRMaj(3, 4);
        CommonOps_DDRM.insert((DMatrix)KR, (DMatrix)P, (int)0, (int)0);
        P.set(0, 3, lambda * e2.x);
        P.set(1, 3, lambda * e2.y);
        P.set(2, 3, lambda * e2.z);
        return P;
    }

    public static void decomposeCameraMatrix(DMatrixRMaj P, DMatrixRMaj K, Se3_F64 pose) {
        DMatrixRMaj KR = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.extract((DMatrix)P, (int)0, (int)3, (int)0, (int)3, (DMatrix)KR, (int)0, (int)0);
        QRDecomposition qr = DecompositionFactory_DDRM.qr((int)3, (int)3);
        if (!CommonOps_DDRM.invert((DMatrixRMaj)KR)) {
            throw new RuntimeException("Inverse failed!  Bad input?");
        }
        if (!qr.decompose((Matrix)KR)) {
            throw new RuntimeException("QR decomposition failed!  Bad input?");
        }
        DMatrixRMaj U = (DMatrixRMaj)qr.getQ(null, false);
        DMatrixRMaj B = (DMatrixRMaj)qr.getR(null, false);
        if (!CommonOps_DDRM.invert((DMatrixRMaj)U, (DMatrixRMaj)pose.getR())) {
            throw new RuntimeException("Inverse failed!  Bad input?");
        }
        Point3D_F64 KT = new Point3D_F64(P.get(0, 3), P.get(1, 3), P.get(2, 3));
        GeometryMath_F64.mult((DMatrixRMaj)B, (GeoTuple3D_F64)KT, (GeoTuple3D_F64)pose.getT());
        if (!CommonOps_DDRM.invert((DMatrixRMaj)B, (DMatrixRMaj)K)) {
            throw new RuntimeException("Inverse failed!  Bad input?");
        }
        CommonOps_DDRM.scale((double)(1.0 / K.get(2, 2)), (DMatrixD1)K);
    }

    public static List<Se3_F64> decomposeEssential(DMatrixRMaj E) {
        DecomposeEssential d = new DecomposeEssential();
        d.decompose(E);
        return d.getSolutions();
    }

    public static List<Tuple2<Se3_F64, Vector3D_F64>> decomposeHomography(DMatrixRMaj H) {
        DecomposeHomography d = new DecomposeHomography();
        d.decompose(H);
        List<Vector3D_F64> solutionsN = d.getSolutionsN();
        List<Se3_F64> solutionsSe = d.getSolutionsSE();
        ArrayList<Tuple2<Se3_F64, Vector3D_F64>> ret = new ArrayList<Tuple2<Se3_F64, Vector3D_F64>>();
        for (int i = 0; i < 4; ++i) {
            ret.add((Tuple2<Se3_F64, Vector3D_F64>)new Tuple2((Object)solutionsSe.get(i), (Object)solutionsN.get(i)));
        }
        return ret;
    }
}

