/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.alg.geo.bundle.CalibratedPoseAndPoint;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class CalibPoseAndPointRodriguesCodec
implements ModelCodec<CalibratedPoseAndPoint> {
    int numViews;
    int numPoints;
    int numViewsUnknown;
    boolean[] knownView;
    Rodrigues_F64 rotation = new Rodrigues_F64();
    DMatrixRMaj R = new DMatrixRMaj(3, 3);
    SingularValueDecomposition<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);

    public void configure(int numViews, int numPoints, int numViewsUnknown, boolean[] knownView) {
        if (numViews < knownView.length) {
            throw new IllegalArgumentException("Number of views is less than knownView length");
        }
        this.numViews = numViews;
        this.numPoints = numPoints;
        this.numViewsUnknown = numViewsUnknown;
        this.knownView = knownView;
    }

    public void decode(double[] input, CalibratedPoseAndPoint outputModel) {
        int i;
        int paramIndex = 0;
        for (i = 0; i < this.numViews; ++i) {
            if (this.knownView[i]) continue;
            Se3_F64 se = outputModel.getWorldToCamera(i);
            this.rotation.setParamVector(input[paramIndex++], input[paramIndex++], input[paramIndex++]);
            ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)this.rotation, (DMatrixRMaj)se.getR());
            Vector3D_F64 T = se.getT();
            T.x = input[paramIndex++];
            T.y = input[paramIndex++];
            T.z = input[paramIndex++];
        }
        for (i = 0; i < this.numPoints; ++i) {
            Point3D_F64 p = outputModel.getPoint(i);
            p.x = input[paramIndex++];
            p.y = input[paramIndex++];
            p.z = input[paramIndex++];
        }
    }

    public void encode(CalibratedPoseAndPoint model, double[] param) {
        int i;
        int paramIndex = 0;
        for (i = 0; i < this.numViews; ++i) {
            if (this.knownView[i]) continue;
            Se3_F64 se = model.getWorldToCamera(i);
            if (!this.svd.decompose((Matrix)se.getR())) {
                throw new RuntimeException("SVD failed");
            }
            DMatrixRMaj U = (DMatrixRMaj)this.svd.getU(null, false);
            DMatrixRMaj V = (DMatrixRMaj)this.svd.getV(null, false);
            CommonOps_DDRM.multTransB((DMatrix1Row)U, (DMatrix1Row)V, (DMatrix1Row)this.R);
            ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)this.R, (Rodrigues_F64)this.rotation);
            param[paramIndex++] = this.rotation.unitAxisRotation.x * this.rotation.theta;
            param[paramIndex++] = this.rotation.unitAxisRotation.y * this.rotation.theta;
            param[paramIndex++] = this.rotation.unitAxisRotation.z * this.rotation.theta;
            Vector3D_F64 T = se.getT();
            param[paramIndex++] = T.x;
            param[paramIndex++] = T.y;
            param[paramIndex++] = T.z;
        }
        for (i = 0; i < this.numPoints; ++i) {
            Point3D_F64 p = model.getPoint(i);
            param[paramIndex++] = p.x;
            param[paramIndex++] = p.y;
            param[paramIndex++] = p.z;
        }
    }

    public int getParamLength() {
        return this.numViewsUnknown * 6 + this.numPoints * 3;
    }
}

