/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public abstract class FundamentalLinear {
    protected DMatrixRMaj A = new DMatrixRMaj(1, 9);
    protected SingularValueDecomposition_F64<DMatrixRMaj> svdNull = DecompositionFactory_DDRM.svd((int)9, (int)9, (boolean)false, (boolean)true, (boolean)false);
    protected SingularValueDecomposition_F64<DMatrixRMaj> svdConstraints = DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);
    protected DMatrixRMaj svdU;
    protected DMatrixRMaj svdS;
    protected DMatrixRMaj svdV;
    protected DMatrixRMaj temp0 = new DMatrixRMaj(3, 3);
    protected DMatrixRMaj N1 = new DMatrixRMaj(3, 3);
    protected DMatrixRMaj N2 = new DMatrixRMaj(3, 3);
    boolean computeFundamental;

    public FundamentalLinear(boolean computeFundamental) {
        this.computeFundamental = computeFundamental;
    }

    protected boolean projectOntoEssential(DMatrixRMaj E) {
        if (!this.svdConstraints.decompose((Matrix)E)) {
            return false;
        }
        this.svdV = (DMatrixRMaj)this.svdConstraints.getV((Matrix)this.svdV, false);
        this.svdU = (DMatrixRMaj)this.svdConstraints.getU((Matrix)this.svdU, false);
        this.svdS = (DMatrixRMaj)this.svdConstraints.getW((Matrix)this.svdS);
        SingularOps_DDRM.descendingOrder((DMatrixRMaj)this.svdU, (boolean)false, (DMatrixRMaj)this.svdS, (DMatrixRMaj)this.svdV, (boolean)false);
        this.svdS.unsafe_set(0, 0, 1.0);
        this.svdS.unsafe_set(1, 1, 1.0);
        this.svdS.unsafe_set(2, 2, 0.0);
        CommonOps_DDRM.mult((DMatrix1Row)this.svdU, (DMatrix1Row)this.svdS, (DMatrix1Row)this.temp0);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.temp0, (DMatrix1Row)this.svdV, (DMatrix1Row)E);
        return true;
    }

    protected boolean projectOntoFundamentalSpace(DMatrixRMaj F) {
        if (!this.svdConstraints.decompose((Matrix)F)) {
            return false;
        }
        this.svdV = (DMatrixRMaj)this.svdConstraints.getV((Matrix)this.svdV, false);
        this.svdU = (DMatrixRMaj)this.svdConstraints.getU((Matrix)this.svdU, false);
        this.svdS = (DMatrixRMaj)this.svdConstraints.getW((Matrix)this.svdS);
        SingularOps_DDRM.descendingOrder((DMatrixRMaj)this.svdU, (boolean)false, (DMatrixRMaj)this.svdS, (DMatrixRMaj)this.svdV, (boolean)false);
        this.svdS.set(2, 2, 0.0);
        CommonOps_DDRM.mult((DMatrix1Row)this.svdU, (DMatrix1Row)this.svdS, (DMatrix1Row)this.temp0);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.temp0, (DMatrix1Row)this.svdV, (DMatrix1Row)F);
        return true;
    }

    protected void undoNormalizationF(DMatrixRMaj M, DMatrixRMaj N1, DMatrixRMaj N2) {
        CommonOps_DDRM.multTransA((DMatrix1Row)N2, (DMatrix1Row)M, (DMatrix1Row)this.temp0);
        CommonOps_DDRM.mult((DMatrix1Row)this.temp0, (DMatrix1Row)N1, (DMatrix1Row)M);
    }

    protected void createA(List<AssociatedPair> points, DMatrixRMaj A) {
        A.reshape(points.size(), 9, false);
        A.zero();
        Point2D_F64 f_norm = new Point2D_F64();
        Point2D_F64 s_norm = new Point2D_F64();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            LowLevelMultiViewOps.applyPixelNormalization(this.N1, f, f_norm);
            LowLevelMultiViewOps.applyPixelNormalization(this.N2, s, s_norm);
            A.unsafe_set(i, 0, s_norm.x * f_norm.x);
            A.unsafe_set(i, 1, s_norm.x * f_norm.y);
            A.unsafe_set(i, 2, s_norm.x);
            A.unsafe_set(i, 3, s_norm.y * f_norm.x);
            A.unsafe_set(i, 4, s_norm.y * f_norm.y);
            A.unsafe_set(i, 5, s_norm.y);
            A.unsafe_set(i, 6, f_norm.x);
            A.unsafe_set(i, 7, f_norm.y);
            A.unsafe_set(i, 8, 1.0);
        }
    }

    public DMatrixRMaj getSvdU() {
        return this.svdU;
    }

    public DMatrixRMaj getSvdS() {
        return this.svdS;
    }

    public DMatrixRMaj getSvdV() {
        return this.svdV;
    }

    public boolean isComputeFundamental() {
        return this.computeFundamental;
    }
}

