/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolver;

public class HomographyResidualSampson
implements ModelObservationResidualN<DMatrixRMaj, AssociatedPair> {
    DMatrixRMaj H;
    Point2D_F64 temp = new Point2D_F64();
    DMatrixRMaj J = new DMatrixRMaj(2, 4);
    DMatrixRMaj JJ = new DMatrixRMaj(2, 2);
    DMatrixRMaj e = new DMatrixRMaj(2, 1);
    DMatrixRMaj x = new DMatrixRMaj(2, 1);
    DMatrixRMaj error = new DMatrixRMaj(4, 1);
    LinearSolver<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear((int)2);

    @Override
    public void setModel(DMatrixRMaj H) {
        this.H = H;
    }

    @Override
    public int computeResiduals(AssociatedPair p, double[] residuals, int index) {
        GeometryMath_F64.mult((DMatrixRMaj)this.H, (GeoTuple2D_F64)p.p1, (GeoTuple2D_F64)this.temp);
        double top1 = this.error1(p.p1.x, p.p1.y, p.p2.x, p.p2.y);
        double top2 = this.error2(p.p1.x, p.p1.y, p.p2.x, p.p2.y);
        this.computeJacobian(p.p1, p.p2);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.J, (DMatrix1Row)this.J, (DMatrix1Row)this.JJ);
        this.e.data[0] = -top1;
        this.e.data[1] = -top2;
        if (this.solver.setA((Matrix)this.JJ)) {
            this.solver.solve((Matrix)this.e, (Matrix)this.x);
            CommonOps_DDRM.multTransA((DMatrix1Row)this.J, (DMatrix1Row)this.x, (DMatrix1Row)this.error);
            residuals[index++] = this.error.data[0];
            residuals[index++] = this.error.data[1];
            residuals[index++] = this.error.data[2];
            residuals[index++] = this.error.data[3];
        } else {
            residuals[index++] = 0.0;
            residuals[index++] = 0.0;
            residuals[index++] = 0.0;
            residuals[index++] = 0.0;
        }
        return index;
    }

    public double error1(double x1, double y1, double x2, double y2) {
        double ret = -(x1 * this.H.get(1, 0) + y1 * this.H.get(1, 1) + this.H.get(1, 2));
        return ret += y2 * (x1 * this.H.get(2, 0) + y1 * this.H.get(2, 1) + this.H.get(2, 2));
    }

    public double error2(double x1, double y1, double x2, double y2) {
        double ret = x1 * this.H.get(0, 0) + y1 * this.H.get(0, 1) + this.H.get(0, 2);
        return ret -= x2 * (x1 * this.H.get(2, 0) + y1 * this.H.get(2, 1) + this.H.get(2, 2));
    }

    public void computeJacobian(Point2D_F64 x1, Point2D_F64 x2) {
        this.J.data[0] = -this.H.get(1, 0) + x2.y * this.H.get(2, 0);
        this.J.data[1] = -this.H.get(1, 1) + x2.y * this.H.get(2, 1);
        this.J.data[2] = 0.0;
        this.J.data[3] = x1.x * this.H.get(2, 0) + x1.y * this.H.get(2, 1) + this.H.get(2, 2);
        this.J.data[4] = this.H.get(0, 0) - x2.x * this.H.get(2, 0);
        this.J.data[5] = this.H.get(0, 1) - x2.x * this.H.get(2, 1);
        this.J.data[6] = -this.J.data[3];
        this.J.data[7] = 0.0;
    }

    @Override
    public int getN() {
        return 4;
    }
}

