/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.impl;

import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.pinhole.PinholeNtoP_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ImplPerspectiveOps_F64 {
    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, DMatrixRMaj adjustMatrix, C adjustedParam) {
        if (adjustedParam == null) {
            adjustedParam = (CameraPinhole)parameters.createLike();
        }
        adjustedParam.set(parameters);
        DMatrixRMaj K = ImplPerspectiveOps_F64.calibrationMatrix(parameters, null);
        DMatrixRMaj K_adj = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)adjustMatrix, (DMatrix1Row)K, (DMatrix1Row)K_adj);
        ImplPerspectiveOps_F64.matrixToParam(K_adj, parameters.width, parameters.height, adjustedParam);
        return adjustedParam;
    }

    public static DMatrixRMaj calibrationMatrix(double fx, double fy, double skew, double xc, double yc) {
        return new DMatrixRMaj(3, 3, true, new double[]{fx, skew, xc, 0.0, fy, yc, 0.0, 0.0, 1.0});
    }

    public static DMatrixRMaj calibrationMatrix(CameraPinhole param, DMatrixRMaj K) {
        if (K == null) {
            K = new DMatrixRMaj(3, 3);
        }
        CommonOps_DDRM.fill((DMatrixD1)K, (double)0.0);
        K.data[0] = param.fx;
        K.data[1] = param.skew;
        K.data[2] = param.cx;
        K.data[4] = param.fy;
        K.data[5] = param.cy;
        K.data[8] = 1.0;
        return K;
    }

    public static <C extends CameraPinhole> C matrixToParam(DMatrixRMaj K, int width, int height, C param) {
        if (param == null) {
            param = new CameraPinhole();
        }
        param.fx = K.get(0, 0);
        param.fy = K.get(1, 1);
        param.skew = K.get(0, 1);
        param.cx = K.get(0, 2);
        param.cy = K.get(1, 2);
        param.width = width;
        param.height = height;
        return param;
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, double x, double y, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        Point2Transform2_F64 normToPixel = LensDistortionOps.narrow(param).distort_F64(false, true);
        normToPixel.compute(x, y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertNormToPixel(DMatrixRMaj K, Point2D_F64 norm, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        PinholeNtoP_F64 alg = new PinholeNtoP_F64();
        alg.set(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(norm.x, norm.y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertPixelToNorm(CameraModel param, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        Point2Transform2_F64 pixelToNorm = LensDistortionOps.narrow(param).distort_F64(true, false);
        pixelToNorm.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 convertPixelToNorm(DMatrixRMaj K, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        PinholePtoN_F64 alg = new PinholePtoN_F64();
        alg.set(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, DMatrixRMaj K, Point3D_F64 X) {
        Point3D_F64 X_cam = new Point3D_F64();
        SePointOps_F64.transform((Se3_F64)worldToCamera, (Point3D_F64)X, (Point3D_F64)X_cam);
        if (X_cam.z <= 0.0) {
            return null;
        }
        Point2D_F64 norm = new Point2D_F64(X_cam.x / X_cam.z, X_cam.y / X_cam.z);
        if (K == null) {
            return norm;
        }
        return (Point2D_F64)GeometryMath_F64.mult((DMatrixRMaj)K, (GeoTuple2D_F64)norm, (GeoTuple2D_F64)norm);
    }

    public static Point2D_F64 renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X) {
        DMatrixRMaj P = worldToCamera;
        double x = P.data[0] * X.x + P.data[1] * X.y + P.data[2] * X.z + P.data[3];
        double y = P.data[4] * X.x + P.data[5] * X.y + P.data[6] * X.z + P.data[7];
        double z = P.data[8] * X.x + P.data[9] * X.y + P.data[10] * X.z + P.data[11];
        Point2D_F64 pixel = new Point2D_F64();
        pixel.x = x / z;
        pixel.y = y / z;
        return pixel;
    }

    public static DMatrixRMaj createCameraMatrix(DMatrixRMaj R, Vector3D_F64 T, DMatrixRMaj K, DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(3, 4);
        }
        CommonOps_DDRM.insert((DMatrix)R, (DMatrix)ret, (int)0, (int)0);
        ret.data[3] = T.x;
        ret.data[7] = T.y;
        ret.data[11] = T.z;
        if (K == null) {
            return ret;
        }
        DMatrixRMaj temp = new DMatrixRMaj(3, 4);
        CommonOps_DDRM.mult((DMatrix1Row)K, (DMatrix1Row)ret, (DMatrix1Row)temp);
        ret.set((DMatrixD1)temp);
        return ret;
    }
}

