/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.TriangulateTwoViewsCalibrated;
import boofcv.alg.geo.DecomposeEssential;
import boofcv.alg.geo.PositiveDepthConstraintCheck;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ejml.data.DMatrixRMaj;

public class Se3FromEssentialGenerator
implements ModelGenerator<Se3_F64, AssociatedPair> {
    Estimate1ofEpipolar computeEssential;
    DecomposeEssential decomposeE = new DecomposeEssential();
    PositiveDepthConstraintCheck depthCheck;
    DMatrixRMaj E = new DMatrixRMaj(3, 3);

    public Se3FromEssentialGenerator(Estimate1ofEpipolar computeEssential, TriangulateTwoViewsCalibrated triangulate) {
        this.computeEssential = computeEssential;
        this.depthCheck = new PositiveDepthConstraintCheck(triangulate);
    }

    public boolean generate(List<AssociatedPair> dataSet, Se3_F64 model) {
        if (!this.computeEssential.process(dataSet, this.E)) {
            return false;
        }
        this.decomposeE.decompose(this.E);
        List<Se3_F64> candidates = this.decomposeE.getSolutions();
        Se3_F64 bestModel = null;
        int bestCount = -1;
        for (int i = 0; i < candidates.size(); ++i) {
            Se3_F64 s = candidates.get(i);
            int count = 0;
            for (AssociatedPair p : dataSet) {
                if (!this.depthCheck.checkConstraint(p.p1, p.p2, s)) continue;
                ++count;
            }
            if (count <= bestCount) continue;
            bestCount = count;
            bestModel = s;
        }
        model.set(bestModel);
        return true;
    }

    public int getMinimumPoints() {
        return this.computeEssential.getMinimumPoints();
    }
}

