/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class EnforceTrifocalGeometry {
    private SingularValueDecomposition_F64<DMatrixRMaj> svdU;
    private SingularValueDecomposition_F64<DMatrixRMaj> svdV;
    private DMatrixRMaj U = new DMatrixRMaj(27, 18);
    private DMatrixRMaj Up = new DMatrixRMaj(1, 1);
    private DMatrixRMaj xp = new DMatrixRMaj(1, 1);
    private DMatrixRMaj AU = new DMatrixRMaj(1, 1);
    private DMatrixRMaj vectorT = new DMatrixRMaj(27, 1);
    protected DMatrixRMaj E = new DMatrixRMaj(27, 18);

    public EnforceTrifocalGeometry() {
        this.svdU = DecompositionFactory_DDRM.svd((int)10, (int)10, (boolean)true, (boolean)false, (boolean)true);
        this.svdV = DecompositionFactory_DDRM.svd((int)10, (int)10, (boolean)false, (boolean)true, (boolean)false);
        this.svdV = new SafeSvd_DDRM(this.svdV);
    }

    public void process(Point3D_F64 e2, Point3D_F64 e3, DMatrixRMaj A) {
        this.constructE(e2, e3);
        this.svdU.decompose((Matrix)this.E);
        this.svdU.getU((Matrix)this.U, false);
        SingularOps_DDRM.descendingOrder((DMatrixRMaj)this.U, (boolean)false, (double[])this.svdU.getSingularValues(), (int)this.svdU.numberOfSingularValues(), null, (boolean)false);
        int rank = SingularOps_DDRM.rank(this.svdU, (double)1.0E-13);
        this.Up.reshape(this.U.numRows, rank);
        CommonOps_DDRM.extract((DMatrix)this.U, (int)0, (int)this.U.numRows, (int)0, (int)this.Up.numCols, (DMatrix)this.Up, (int)0, (int)0);
        this.AU.reshape(A.numRows, this.Up.numCols);
        CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)this.Up, (DMatrix1Row)this.AU);
        this.svdV.decompose((Matrix)this.AU);
        this.xp.reshape(rank, 1);
        SingularOps_DDRM.nullVector(this.svdV, (boolean)true, (DMatrixRMaj)this.xp);
        CommonOps_DDRM.mult((DMatrix1Row)this.Up, (DMatrix1Row)this.xp, (DMatrix1Row)this.vectorT);
        if (this.vectorT.data[0] > 0.0) {
            CommonOps_DDRM.changeSign((DMatrixD1)this.vectorT);
        }
    }

    public void computeErrorVector(DMatrixRMaj A, DMatrixRMaj errors) {
        errors.reshape(A.numRows, 1);
        CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)this.vectorT, (DMatrix1Row)errors);
    }

    public void extractSolution(TrifocalTensor tensor) {
        tensor.convertFrom(this.vectorT);
    }

    protected void constructE(Point3D_F64 e2, Point3D_F64 e3) {
        this.E.zero();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int row = 9 * i + 3 * j + k;
                    int col1 = j * 3 + i;
                    int col2 = k * 3 + i + 9;
                    this.E.data[row * 18 + col1] = e3.getIndex(k);
                    this.E.data[row * 18 + col2] = -e2.getIndex(j);
                }
            }
        }
    }
}

