/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class TrifocalExtractEpipoles {
    private SingularValueDecomposition_F64<DMatrixRMaj> svd;
    private DMatrixRMaj u1 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj u2 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj u3 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj v1 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj v2 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj v3 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj U = new DMatrixRMaj(3, 3);
    private DMatrixRMaj V = new DMatrixRMaj(3, 3);
    private DMatrixRMaj tempE = new DMatrixRMaj(3, 1);

    public TrifocalExtractEpipoles() {
        this.svd = DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)true);
        this.svd = new SafeSvd_DDRM(this.svd);
    }

    public void process(TrifocalTensor tensor, Point3D_F64 e2, Point3D_F64 e3) {
        this.svd.decompose((Matrix)tensor.T1);
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.v1);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.u1);
        this.svd.decompose((Matrix)tensor.T2);
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.v2);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.u2);
        this.svd.decompose((Matrix)tensor.T3);
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.v3);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.u3);
        for (int i = 0; i < 3; ++i) {
            this.U.set(i, 0, this.u1.get(i));
            this.U.set(i, 1, this.u2.get(i));
            this.U.set(i, 2, this.u3.get(i));
            this.V.set(i, 0, this.v1.get(i));
            this.V.set(i, 1, this.v2.get(i));
            this.V.set(i, 2, this.v3.get(i));
        }
        this.svd.decompose((Matrix)this.U);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.tempE);
        e2.set(this.tempE.get(0), this.tempE.get(1), this.tempE.get(2));
        this.svd.decompose((Matrix)this.V);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.tempE);
        e3.set(this.tempE.get(0), this.tempE.get(1), this.tempE.get(2));
    }
}

