/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.TriangulateTwoViewsCalibrated;
import boofcv.alg.geo.pose.PnPDistanceReprojectionSq;
import boofcv.alg.geo.robust.DistanceHomographySq;
import boofcv.alg.geo.robust.DistanceSe3SymmetricSq;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.alg.geo.robust.Se3FromEssentialGenerator;
import boofcv.factory.geo.ConfigEssential;
import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigHomography;
import boofcv.factory.geo.ConfigLMedS;
import boofcv.factory.geo.ConfigPnP;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.EstimatorToGenerator;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.Point2D3D;
import georegression.fitting.homography.ModelManagerHomography2D_F64;
import georegression.fitting.se.ModelManagerSe3_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class FactoryMultiViewRobust {
    public static LeastMedianOfSquares<Se3_F64, Point2D3D> pnpLMedS(ConfigPnP pnp, ConfigLMedS lmeds) {
        Estimate1ofPnP estimatorPnP = FactoryMultiView.computePnP_1(EnumPNP.P3P_FINSTERWALDER, -1, 1);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        distance.setIntrinsic(pnp.intrinsic.fx, pnp.intrinsic.fy, pnp.intrinsic.skew);
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimatorPnP);
        return new LeastMedianOfSquares(lmeds.randSeed, lmeds.totalCycles, (ModelManager)manager, generator, (DistanceFromModel)distance);
    }

    public static Ransac<Se3_F64, Point2D3D> pnpRansac(ConfigPnP pnp, ConfigRansac ransac) {
        Estimate1ofPnP estimatorPnP = FactoryMultiView.computePnP_1(pnp.which, -1, pnp.numResolve);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        distance.setIntrinsic(pnp.intrinsic.fx, pnp.intrinsic.fy, pnp.intrinsic.skew);
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>(estimatorPnP);
        double threshold = ransac.inlierThreshold * ransac.inlierThreshold;
        return new Ransac(ransac.randSeed, (ModelManager)manager, generator, (DistanceFromModel)distance, ransac.maxIterations, threshold);
    }

    public static LeastMedianOfSquares<Se3_F64, AssociatedPair> essentialLMedS(ConfigEssential essential, ConfigLMedS lmeds) {
        essential.checkValidity();
        Estimate1ofEpipolar essentialAlg = FactoryMultiView.computeEssential_1(essential.which, essential.numResolve);
        return FactoryMultiViewRobust.epipolarLMedS(essentialAlg, essential.intrinsic, lmeds);
    }

    public static LeastMedianOfSquares<Se3_F64, AssociatedPair> fundamentalLMedS(ConfigEssential fundamental, ConfigLMedS lmeds) {
        fundamental.checkValidity();
        Estimate1ofEpipolar essentialAlg = FactoryMultiView.computeEssential_1(fundamental.which, fundamental.numResolve);
        return FactoryMultiViewRobust.epipolarLMedS(essentialAlg, fundamental.intrinsic, lmeds);
    }

    private static LeastMedianOfSquares<Se3_F64, AssociatedPair> epipolarLMedS(Estimate1ofEpipolar epipolar, CameraPinholeRadial intrinsic, ConfigLMedS lmeds) {
        TriangulateTwoViewsCalibrated triangulate = FactoryMultiView.triangulateTwoGeometric();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        Se3FromEssentialGenerator generateEpipolarMotion = new Se3FromEssentialGenerator(epipolar, triangulate);
        DistanceSe3SymmetricSq distanceSe3 = new DistanceSe3SymmetricSq(triangulate, intrinsic.fx, intrinsic.fy, intrinsic.skew, intrinsic.fx, intrinsic.fy, intrinsic.skew);
        return new LeastMedianOfSquares(lmeds.randSeed, lmeds.totalCycles, (ModelManager)manager, (ModelGenerator)generateEpipolarMotion, (DistanceFromModel)distanceSe3);
    }

    public static Ransac<Se3_F64, AssociatedPair> essentialRansac(ConfigEssential essential, ConfigRansac ransac) {
        essential.checkValidity();
        ransac.checkValidity();
        Estimate1ofEpipolar essentialAlg = FactoryMultiView.computeEssential_1(essential.which, essential.numResolve);
        return FactoryMultiViewRobust.epipolarRansac(essentialAlg, essential.intrinsic, ransac);
    }

    public static Ransac<Se3_F64, AssociatedPair> fundamentalRansac(ConfigFundamental essential, ConfigRansac ransac) {
        essential.checkValidity();
        ransac.checkValidity();
        Estimate1ofEpipolar essentialAlg = FactoryMultiView.computeFundamental_1(essential.which, essential.numResolve);
        return FactoryMultiViewRobust.epipolarRansac(essentialAlg, essential.intrinsic, ransac);
    }

    private static Ransac<Se3_F64, AssociatedPair> epipolarRansac(Estimate1ofEpipolar epipolar, CameraPinholeRadial intrinsic, ConfigRansac ransac) {
        TriangulateTwoViewsCalibrated triangulate = FactoryMultiView.triangulateTwoGeometric();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        Se3FromEssentialGenerator generateEpipolarMotion = new Se3FromEssentialGenerator(epipolar, triangulate);
        DistanceSe3SymmetricSq distanceSe3 = new DistanceSe3SymmetricSq(triangulate, intrinsic.fx, intrinsic.fy, intrinsic.skew, intrinsic.fx, intrinsic.fy, intrinsic.skew);
        double ransacTOL = ransac.inlierThreshold * ransac.inlierThreshold * 2.0;
        return new Ransac(ransac.randSeed, (ModelManager)manager, (ModelGenerator)generateEpipolarMotion, (DistanceFromModel)distanceSe3, ransac.maxIterations, ransacTOL);
    }

    public static LeastMedianOfSquares<Homography2D_F64, AssociatedPair> homographyLMedS(ConfigHomography homography, ConfigLMedS lmeds) {
        if (homography == null) {
            homography = new ConfigHomography();
        }
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        GenerateHomographyLinear modelFitter = new GenerateHomographyLinear(homography.normalize);
        DistanceHomographySq distance = new DistanceHomographySq();
        return new LeastMedianOfSquares(lmeds.randSeed, lmeds.totalCycles, (ModelManager)manager, (ModelGenerator)modelFitter, (DistanceFromModel)distance);
    }

    public static Ransac<Homography2D_F64, AssociatedPair> homographyRansac(ConfigHomography homography, ConfigRansac ransac) {
        if (homography == null) {
            homography = new ConfigHomography();
        }
        ModelManagerHomography2D_F64 manager = new ModelManagerHomography2D_F64();
        GenerateHomographyLinear modelFitter = new GenerateHomographyLinear(homography.normalize);
        DistanceHomographySq distance = new DistanceHomographySq();
        double ransacTol = ransac.inlierThreshold * ransac.inlierThreshold;
        return new Ransac(ransac.randSeed, (ModelManager)manager, (ModelGenerator)modelFitter, (DistanceFromModel)distance, ransac.maxIterations, ransacTol);
    }
}

