/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.distort.radtan.LensDistortionRadialTangential;
import boofcv.alg.distort.universal.LensDistortionUniversalOmni;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.distort.PixelTransform2_F64;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.shapes.RectangleLength2D_F32;
import georegression.struct.shapes.RectangleLength2D_F64;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class LensDistortionOps {
    public static <T extends ImageBase<T>, O extends CameraPinhole, D extends CameraPinhole> ImageDistort<T, T> changeCameraModel(AdjustmentType type, BorderType borderType, O original, D desired, D modified, ImageType<T> imageType) {
        boolean skip;
        Class bandType = imageType.getImageClass();
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixelS interp = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)borderType, (Class)bandType);
        Point2Transform2_F32 undistToDist = LensDistortionOps.transformChangeModel_F32(type, original, desired, true, modified);
        ImageDistort distort = FactoryDistort.distort((boolean)true, (InterpolatePixel)interp, imageType);
        distort.setModel((PixelTransform2_F32)new PointToPixelTransform_F32(undistToDist));
        distort.setRenderAll(!skip);
        return distort;
    }

    public static <O extends CameraPinhole, D extends CameraPinhole> Point2Transform2_F32 transformChangeModel_F32(AdjustmentType type, O paramOriginal, D paramDesired, boolean desiredToOriginal, D paramMod) {
        RectangleLength2D_F32 bound;
        LensDistortionNarrowFOV original = LensDistortionOps.narrow(paramOriginal);
        LensDistortionNarrowFOV desired = LensDistortionOps.narrow(paramDesired);
        Point2Transform2_F32 ori_p_to_n = original.undistort_F32(true, false);
        Point2Transform2_F32 des_n_to_p = desired.distort_F32(false, true);
        SequencePoint2Transform2_F32 ori_to_des = new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{ori_p_to_n, des_n_to_p});
        if (type == AdjustmentType.FULL_VIEW) {
            bound = DistortImageOps.boundBox_F32((int)paramOriginal.width, (int)paramOriginal.height, (PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)ori_to_des));
        } else if (type == AdjustmentType.EXPAND) {
            bound = LensDistortionOps.boundBoxInside(paramOriginal.width, paramOriginal.height, (PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)ori_to_des));
            LensDistortionOps.roundInside(bound);
        } else if (type == AdjustmentType.NONE) {
            bound = new RectangleLength2D_F32(0.0f, 0.0f, (float)paramDesired.width, (float)paramDesired.height);
        } else {
            throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
        }
        float scaleX = bound.width / (float)paramDesired.width;
        float scaleY = bound.height / (float)paramDesired.height;
        float scale = type == AdjustmentType.FULL_VIEW ? Math.max(scaleX, scaleY) : (type == AdjustmentType.EXPAND ? Math.min(scaleX, scaleY) : 1.0f);
        float deltaX = (float)((double)bound.x0 + (double)((scaleX - scale) * (float)paramDesired.width) / 2.0);
        float deltaY = (float)((double)bound.y0 + (double)((scaleY - scale) * (float)paramDesired.height) / 2.0);
        FMatrixRMaj A = new FMatrixRMaj(3, 3, true, new float[]{scale, 0.0f, deltaX, 0.0f, scale, deltaY, 0.0f, 0.0f, 1.0f});
        FMatrixRMaj A_inv = new FMatrixRMaj(3, 3);
        if (!CommonOps_FDRM.invert((FMatrixRMaj)A, (FMatrixRMaj)A_inv)) {
            throw new RuntimeException("Failed to invert adjustment matrix.  Probably bad.");
        }
        if (paramMod != null) {
            PerspectiveOps.adjustIntrinsic(paramDesired, A_inv, paramMod);
        }
        if (desiredToOriginal) {
            Point2Transform2_F32 des_p_to_n = desired.undistort_F32(true, false);
            Point2Transform2_F32 ori_n_to_p = original.distort_F32(false, true);
            PointTransformHomography_F32 adjust = new PointTransformHomography_F32(A);
            return new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{adjust, des_p_to_n, ori_n_to_p});
        }
        PointTransformHomography_F32 adjust = new PointTransformHomography_F32(A_inv);
        return new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{ori_to_des, adjust});
    }

    public static LensDistortionNarrowFOV narrow(CameraModel param) {
        if (param instanceof CameraPinholeRadial) {
            CameraPinholeRadial c = (CameraPinholeRadial)param;
            if (c.isDistorted()) {
                return new LensDistortionRadialTangential(c);
            }
            return new LensDistortionPinhole(c);
        }
        if (param instanceof CameraPinhole) {
            CameraPinhole c = (CameraPinhole)param;
            return new LensDistortionPinhole(c);
        }
        throw new IllegalArgumentException("Unknown camera model " + param.getClass().getSimpleName());
    }

    public static LensDistortionWideFOV wide(CameraModel param) {
        if (param instanceof CameraUniversalOmni) {
            return new LensDistortionUniversalOmni((CameraUniversalOmni)param);
        }
        throw new IllegalArgumentException("Unknown camera model " + param.getClass().getSimpleName());
    }

    public static RectangleLength2D_F32 boundBoxInside(int srcWidth, int srcHeight, PixelTransform2_F32 transform) {
        transform.compute(0, 0);
        float x0 = transform.distX;
        float y0 = transform.distY;
        transform.compute(srcWidth, 0);
        float x1 = transform.distX;
        transform.compute(0, srcHeight);
        float y1 = transform.distY;
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            if (transform.distY > y0) {
                y0 = transform.distY;
            }
            transform.compute(x, srcHeight);
            if (!(transform.distY < y1)) continue;
            y1 = transform.distY;
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            if (transform.distX > x0) {
                x0 = transform.distX;
            }
            transform.compute(srcWidth, y);
            if (!(transform.distX < x1)) continue;
            x1 = transform.distX;
        }
        return new RectangleLength2D_F32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F64 boundBoxInside(int srcWidth, int srcHeight, PixelTransform2_F64 transform) {
        transform.compute(0, 0);
        double x0 = transform.distX;
        double y0 = transform.distY;
        transform.compute(srcWidth, 0);
        double x1 = transform.distX;
        transform.compute(0, srcHeight);
        double y1 = transform.distY;
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            if (transform.distY > y0) {
                y0 = transform.distY;
            }
            transform.compute(x, srcHeight);
            if (!(transform.distY < y1)) continue;
            y1 = transform.distY;
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            if (transform.distX > x0) {
                x0 = transform.distX;
            }
            transform.compute(srcWidth, y);
            if (!(transform.distX < x1)) continue;
            x1 = transform.distX;
        }
        return new RectangleLength2D_F64(x0, y0, x1 - x0, y1 - y0);
    }

    public static void roundInside(RectangleLength2D_F32 bound) {
        float x0 = (float)Math.ceil(bound.x0);
        float y0 = (float)Math.ceil(bound.y0);
        float x1 = (float)Math.floor(bound.x0 + bound.width);
        float y1 = (float)Math.floor(bound.y0 + bound.height);
        bound.x0 = x0;
        bound.y0 = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }

    public static void roundInside(RectangleLength2D_F64 bound) {
        double x0 = Math.ceil(bound.x0);
        double y0 = Math.ceil(bound.y0);
        double x1 = Math.floor(bound.x0 + bound.width);
        double y1 = Math.floor(bound.y0 + bound.height);
        bound.x0 = x0;
        bound.y0 = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }
}

