/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F64;

public class RemoveRadialNtoN_F64
implements Point2Transform2_F64 {
    protected RadialTangential_F64 params;
    private double tol = GrlConstants.DCONV_TOL_A;

    public RemoveRadialNtoN_F64() {
    }

    public RemoveRadialNtoN_F64(double tol) {
        this.tol = tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public RemoveRadialNtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        RemoveRadialNtoN_F64.removeRadial(x, y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }

    public static void removeRadial(double x, double y, double[] radial, double t1, double t2, Point2D_F64 out, double tol) {
        double origX = x;
        double origY = y;
        double prevSum = 0.0;
        for (int iter = 0; iter < 500; ++iter) {
            double r2;
            double ri2 = r2 = x * x + y * y;
            double sum = 0.0;
            for (int i = 0; i < radial.length; ++i) {
                sum += radial[i] * ri2;
                ri2 *= r2;
            }
            double tx = 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
            double ty = t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
            x = (origX - tx) / (1.0 + sum);
            y = (origY - ty) / (1.0 + sum);
            if (Math.abs(prevSum - sum) <= tol) break;
            prevSum = sum;
        }
        out.set(x, y);
    }
}

