/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.radtan.LensDistortionRadialTangential;
import boofcv.alg.distort.spherical.EquirectangularDistortBase_F64;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public class PinholeRadialToEquirectangular_F64
extends EquirectangularDistortBase_F64 {
    private CameraPinholeRadial pinhole;

    public void setPinhole(CameraPinholeRadial pinhole) {
        this.pinhole = pinhole;
        this.declareVectors(pinhole.width, pinhole.height);
        Point2Transform2_F64 pixelToNormalized = new LensDistortionRadialTangential(pinhole).undistort_F64(true, false);
        Point2D_F64 norm = new Point2D_F64();
        for (int pixelY = 0; pixelY < pinhole.height; ++pixelY) {
            for (int pixelX = 0; pixelX < pinhole.width; ++pixelX) {
                pixelToNormalized.compute((double)pixelX, (double)pixelY, norm);
                Point3D_F64 v = this.vectors[pixelY * pinhole.width + pixelX];
                v.set(norm.x, norm.y, 1.0);
            }
        }
    }

    public CameraPinholeRadial getPinhole() {
        return this.pinhole;
    }
}

