/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class DecomposeEssential {
    private SingularValueDecomposition<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);
    DMatrixRMaj U;
    DMatrixRMaj S;
    DMatrixRMaj V;
    List<Se3_F64> solutions = new ArrayList<Se3_F64>();
    DMatrixRMaj E_copy = new DMatrixRMaj(3, 3);
    DMatrixRMaj temp = new DMatrixRMaj(3, 3);
    DMatrixRMaj temp2 = new DMatrixRMaj(3, 3);
    DMatrixRMaj Rz = new DMatrixRMaj(3, 3);

    public DecomposeEssential() {
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.Rz.set(0, 1, 1.0);
        this.Rz.set(1, 0, -1.0);
        this.Rz.set(2, 2, 1.0);
    }

    public void decompose(DMatrixRMaj E) {
        if (this.svd.inputModified()) {
            this.E_copy.set((DMatrixD1)E);
            E = this.E_copy;
        }
        if (!this.svd.decompose((Matrix)E)) {
            throw new RuntimeException("Svd some how failed");
        }
        this.U = (DMatrixRMaj)this.svd.getU((Matrix)this.U, false);
        this.V = (DMatrixRMaj)this.svd.getV((Matrix)this.V, false);
        this.S = (DMatrixRMaj)this.svd.getW((Matrix)this.S);
        SingularOps_DDRM.descendingOrder((DMatrixRMaj)this.U, (boolean)false, (DMatrixRMaj)this.S, (DMatrixRMaj)this.V, (boolean)false);
        this.decompose(this.U, this.S, this.V);
    }

    public void decompose(DMatrixRMaj U, DMatrixRMaj S, DMatrixRMaj V) {
        if (CommonOps_DDRM.det((DMatrixRMaj)U) < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)U);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)S);
        }
        if (CommonOps_DDRM.det((DMatrixRMaj)V) < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)V);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)S);
        }
        this.extractTransform(U, V, S, this.solutions.get(0), true, true);
        this.extractTransform(U, V, S, this.solutions.get(1), true, false);
        this.extractTransform(U, V, S, this.solutions.get(2), false, false);
        this.extractTransform(U, V, S, this.solutions.get(3), false, true);
    }

    public List<Se3_F64> getSolutions() {
        return this.solutions;
    }

    private void extractTransform(DMatrixRMaj U, DMatrixRMaj V, DMatrixRMaj S, Se3_F64 se, boolean optionA, boolean optionB) {
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        if (optionA) {
            CommonOps_DDRM.mult((DMatrix1Row)U, (DMatrix1Row)this.Rz, (DMatrix1Row)this.temp);
        } else {
            CommonOps_DDRM.multTransB((DMatrix1Row)U, (DMatrix1Row)this.Rz, (DMatrix1Row)this.temp);
        }
        CommonOps_DDRM.multTransB((DMatrix1Row)this.temp, (DMatrix1Row)V, (DMatrix1Row)R);
        if (optionB) {
            CommonOps_DDRM.multTransB((DMatrix1Row)U, (DMatrix1Row)this.Rz, (DMatrix1Row)this.temp);
        } else {
            CommonOps_DDRM.mult((DMatrix1Row)U, (DMatrix1Row)this.Rz, (DMatrix1Row)this.temp);
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.temp, (DMatrix1Row)S, (DMatrix1Row)this.temp2);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.temp2, (DMatrix1Row)U, (DMatrix1Row)this.temp);
        T.x = this.temp.get(2, 1);
        T.y = this.temp.get(0, 2);
        T.z = this.temp.get(1, 0);
    }
}

