/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.radtan.LensDistortionRadialTangential;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class WorldToCameraToPixel {
    private Se3_F64 worldToCamera;
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2Transform2_F64 normToPixel;

    public void configure(CameraPinholeRadial intrinsic, Se3_F64 worldToCamera) {
        this.configure(new LensDistortionRadialTangential(intrinsic), worldToCamera);
    }

    public void configure(LensDistortionNarrowFOV distortion, Se3_F64 worldToCamera) {
        this.worldToCamera = worldToCamera;
        this.normToPixel = distortion.distort_F64(false, true);
    }

    public boolean transform(Point3D_F64 worldPt, Point2D_F64 pixelPt) {
        SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)worldPt, (Point3D_F64)this.cameraPt);
        if (this.cameraPt.z <= 0.0) {
            return false;
        }
        this.normToPixel.compute(this.cameraPt.x / this.cameraPt.z, this.cameraPt.y / this.cameraPt.z, pixelPt);
        return true;
    }

    public Point2D_F64 transform(Point3D_F64 worldPt) {
        Point2D_F64 out = new Point2D_F64();
        if (this.transform(worldPt, out)) {
            return out;
        }
        return null;
    }
}

