/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.alg.geo.bundle.CalibratedPoseAndPoint;
import boofcv.alg.geo.bundle.PointIndexObservation;
import boofcv.alg.geo.bundle.ViewPointObservations;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.struct.FastQueue;

public class CalibPoseAndPointResiduals
implements FunctionNtoM {
    ModelCodec<CalibratedPoseAndPoint> codec;
    CalibratedPoseAndPoint model;
    List<ViewPointObservations> observations;
    int numObservations;
    Point3D_F64 cameraPt = new Point3D_F64();

    public void configure(ModelCodec<CalibratedPoseAndPoint> codec, CalibratedPoseAndPoint model, List<ViewPointObservations> obs) {
        this.model = model;
        this.codec = codec;
        this.observations = obs;
        this.numObservations = 0;
        for (int view = 0; view < model.getNumViews(); ++view) {
            this.numObservations += obs.get(view).getPoints().size() * 2;
        }
    }

    public int getNumOfInputsN() {
        return this.codec.getParamLength();
    }

    public int getNumOfOutputsM() {
        return this.numObservations;
    }

    public void process(double[] input, double[] output) {
        this.codec.decode(input, (Object)this.model);
        this.process(this.model, output);
    }

    public void process(CalibratedPoseAndPoint model, double[] output) {
        int outputIndex = 0;
        for (int view = 0; view < model.getNumViews(); ++view) {
            Se3_F64 worldToCamera = model.getWorldToCamera(view);
            FastQueue<PointIndexObservation> observedPts = this.observations.get(view).getPoints();
            for (int i = 0; i < observedPts.size; ++i) {
                PointIndexObservation o = ((PointIndexObservation[])observedPts.data)[i];
                Point3D_F64 worldPt = model.getPoint(o.pointIndex);
                SePointOps_F64.transform((Se3_F64)worldToCamera, (Point3D_F64)worldPt, (Point3D_F64)this.cameraPt);
                output[outputIndex++] = this.cameraPt.x / this.cameraPt.z - o.obs.x;
                output[outputIndex++] = this.cameraPt.y / this.cameraPt.z - o.obs.y;
            }
        }
    }
}

