/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class DistanceEpipolarConstraint
implements DistanceFromModel<DMatrixRMaj, AssociatedPair> {
    DMatrixRMaj M = new DMatrixRMaj(3, 3);

    public void setModel(DMatrixRMaj F) {
        double v = CommonOps_DDRM.elementSumAbs((DMatrixD1)F);
        CommonOps_DDRM.scale((double)(1.0 / v), (DMatrixD1)F, (DMatrixD1)this.M);
    }

    public double computeDistance(AssociatedPair pt) {
        return Math.abs(GeometryMath_F64.innerProd((GeoTuple2D_F64)pt.p2, (DMatrixRMaj)this.M, (GeoTuple2D_F64)pt.p1));
    }

    public void computeDistance(List<AssociatedPair> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            distance[i] = this.computeDistance(associatedPairs.get(i));
        }
    }

    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    public Class<DMatrixRMaj> getModelType() {
        return DMatrixRMaj.class;
    }
}

