/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraPinholeRadial;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.Serializable;
import org.ejml.data.DMatrixRMaj;

public class StereoParameters
implements Serializable {
    public static final long serialVersionUID = 1L;
    public CameraPinholeRadial left;
    public CameraPinholeRadial right;
    public Se3_F64 rightToLeft;

    public StereoParameters(StereoParameters param) {
        this(param.left, param.right, param.getRightToLeft());
    }

    public StereoParameters(CameraPinholeRadial left, CameraPinholeRadial right, Se3_F64 rightToLeft) {
        this.left = new CameraPinholeRadial(left);
        this.rightToLeft = rightToLeft.copy();
        this.right = new CameraPinholeRadial(right);
    }

    public StereoParameters() {
    }

    public CameraPinholeRadial getLeft() {
        return this.left;
    }

    public void setLeft(CameraPinholeRadial left) {
        this.left = left;
    }

    public Se3_F64 getRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(Se3_F64 rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public CameraPinholeRadial getRight() {
        return this.right;
    }

    public void setRight(CameraPinholeRadial right) {
        this.right = right;
    }

    public double getBaseline() {
        return this.rightToLeft.getT().norm();
    }

    public void print() {
        double[] euler = ConvertRotation3D_F64.matrixToEuler((DMatrixRMaj)this.rightToLeft.getR(), (EulerType)EulerType.XYZ, (double[])null);
        Vector3D_F64 t = this.rightToLeft.getT();
        System.out.println();
        System.out.println("Left Camera");
        this.left.print();
        System.out.println();
        System.out.println("Right Camera");
        this.right.print();
        System.out.println("Right to Left");
        System.out.printf("  Euler XYZ   [ %8.3f , %8.3f , %8.3f ]\n", euler[0], euler[1], euler[2]);
        System.out.printf("  Translation [ %8.3f , %8.3f , %8.3f ]\n", t.x, t.y, t.z);
    }
}

