/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.radtan.LensDistortionRadialTangential;
import boofcv.alg.distort.spherical.EquirectangularDistortBase_F32;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;

public class PinholeRadialToEquirectangular_F32
extends EquirectangularDistortBase_F32 {
    private CameraPinholeRadial pinhole;

    public void setPinhole(CameraPinholeRadial pinhole) {
        this.pinhole = pinhole;
        this.declareVectors(pinhole.width, pinhole.height);
        Point2Transform2_F32 pixelToNormalized = new LensDistortionRadialTangential(pinhole).undistort_F32(true, false);
        Point2D_F32 norm = new Point2D_F32();
        for (int pixelY = 0; pixelY < pinhole.height; ++pixelY) {
            for (int pixelX = 0; pixelX < pinhole.width; ++pixelX) {
                pixelToNormalized.compute((float)pixelX, (float)pixelY, norm);
                Point3D_F32 v = this.vectors[pixelY * pinhole.width + pixelX];
                v.set(norm.x, norm.y, 1.0f);
            }
        }
    }

    public CameraPinholeRadial getPinhole() {
        return this.pinhole;
    }
}

