/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.f.FundamentalLinear;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class FundamentalLinear8
extends FundamentalLinear {
    public FundamentalLinear8(boolean computeFundamental) {
        super(computeFundamental);
    }

    public boolean process(List<AssociatedPair> points, DMatrixRMaj solution) {
        if (points.size() < 8) {
            throw new IllegalArgumentException("Must be at least 8 points. Was only " + points.size());
        }
        LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
        this.createA(points, this.A);
        if (this.process(this.A, solution)) {
            return false;
        }
        this.undoNormalizationF(solution, this.N1, this.N2);
        if (this.computeFundamental) {
            return this.projectOntoFundamentalSpace(solution);
        }
        return this.projectOntoEssential(solution);
    }

    protected boolean process(DMatrixRMaj A, DMatrixRMaj F) {
        if (!this.svdNull.decompose((Matrix)A)) {
            return true;
        }
        if (A.numRows > 8) {
            SingularOps_DDRM.nullVector((SingularValueDecomposition_F64)this.svdNull, (boolean)true, (DMatrixRMaj)F);
        } else {
            DMatrixRMaj V = (DMatrixRMaj)this.svdNull.getV(null, false);
            SpecializedOps_DDRM.subvector((DMatrix1Row)V, (int)0, (int)8, (int)V.numCols, (boolean)false, (int)0, (DMatrix1Row)F);
        }
        return false;
    }
}

