/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.abst.distort.FDistort;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;

public class RemovePerspectiveDistortion<T extends ImageBase<T>> {
    FDistort distort;
    Estimate1ofEpipolar computeHomography = FactoryMultiView.computeHomographyDLT(true);
    DMatrixRMaj H = new DMatrixRMaj(3, 3);
    FMatrixRMaj H32 = new FMatrixRMaj(3, 3);
    PointTransformHomography_F32 transform = new PointTransformHomography_F32();
    ArrayList<AssociatedPair> associatedPairs = new ArrayList();
    T output;

    public RemovePerspectiveDistortion(int width, int height, ImageType<T> imageType) {
        this(width, height);
        this.output = imageType.createImage(width, height);
        this.distort = new FDistort(imageType);
        this.distort.output(this.output);
        this.distort.interp(InterpolationType.BILINEAR).transform((Point2Transform2_F32)this.transform);
    }

    public RemovePerspectiveDistortion(int width, int height) {
        for (int i = 0; i < 4; ++i) {
            this.associatedPairs.add(new AssociatedPair());
        }
        this.associatedPairs.get((int)0).p1.set(0.0, 0.0);
        this.associatedPairs.get((int)1).p1.set((double)width, 0.0);
        this.associatedPairs.get((int)2).p1.set((double)width, (double)height);
        this.associatedPairs.get((int)3).p1.set(0.0, (double)height);
    }

    public boolean apply(T input, Point2D_F64 corner0, Point2D_F64 corner1, Point2D_F64 corner2, Point2D_F64 corner3) {
        if (this.createTransform(corner0, corner1, corner2, corner3)) {
            this.distort.input(input).apply();
            return true;
        }
        return false;
    }

    public boolean createTransform(Point2D_F64 tl, Point2D_F64 tr, Point2D_F64 br, Point2D_F64 bl) {
        this.associatedPairs.get((int)0).p2.set(tl);
        this.associatedPairs.get((int)1).p2.set(tr);
        this.associatedPairs.get((int)2).p2.set(br);
        this.associatedPairs.get((int)3).p2.set(bl);
        if (!this.computeHomography.process(this.associatedPairs, this.H)) {
            return false;
        }
        ConvertMatrixData.convert((DMatrixRMaj)this.H, (FMatrixRMaj)this.H32);
        this.transform.set((FMatrix)this.H32);
        return true;
    }

    public DMatrixRMaj getH() {
        return this.H;
    }

    public PointTransformHomography_F32 getTransform() {
        return this.transform;
    }

    public T getOutput() {
        return this.output;
    }
}

