/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Point2D_F64;
import org.ejml.data.DMatrixRMaj;

public class NormalizationPoint2D {
    public double meanX;
    public double stdX;
    public double meanY;
    public double stdY;

    public NormalizationPoint2D() {
    }

    public NormalizationPoint2D(double meanX, double stdX, double meanY, double stdY) {
        this.meanX = meanX;
        this.stdX = stdX;
        this.meanY = meanY;
        this.stdY = stdY;
    }

    public void apply(Point2D_F64 p) {
        p.x = (p.x - this.meanX) / this.stdX;
        p.y = (p.y - this.meanY) / this.stdY;
    }

    public void apply(Point2D_F64 input, Point2D_F64 output) {
        output.x = (input.x - this.meanX) / this.stdX;
        output.y = (input.y - this.meanY) / this.stdY;
    }

    public void remove(Point2D_F64 p) {
        p.x = p.x * this.stdX + this.meanX;
        p.y = p.y * this.stdY + this.meanY;
    }

    public void remove(Point2D_F64 input, Point2D_F64 output) {
        output.x = input.x * this.stdX + this.meanX;
        output.y = input.y * this.stdY + this.meanY;
    }

    public DMatrixRMaj matrix() {
        DMatrixRMaj M = new DMatrixRMaj(3, 3);
        M.set(0, 0, 1.0 / this.stdX);
        M.set(1, 1, 1.0 / this.stdY);
        M.set(0, 2, -this.meanX / this.stdX);
        M.set(1, 2, -this.meanY / this.stdY);
        M.set(2, 2, 1.0);
        return M;
    }

    public DMatrixRMaj matrixInv() {
        DMatrixRMaj M = new DMatrixRMaj(3, 3);
        M.set(0, 0, this.stdX);
        M.set(1, 1, this.stdY);
        M.set(0, 2, this.meanX);
        M.set(1, 2, this.meanY);
        M.set(2, 2, 1.0);
        return M;
    }

    public boolean isEquals(NormalizationPoint2D a, double tol) {
        if (Math.abs(a.meanX - this.meanX) > tol) {
            return false;
        }
        if (Math.abs(a.meanY - this.meanY) > tol) {
            return false;
        }
        if (Math.abs(a.stdX - this.stdX) > tol) {
            return false;
        }
        return !(Math.abs(a.stdY - this.stdY) > tol);
    }
}

