/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.alg.geo.impl.ImplPerspectiveOps_F32;
import boofcv.alg.geo.impl.ImplPerspectiveOps_F64;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;

public class PerspectiveOps {
    public static CameraPinhole createIntrinsic(int width, int height, double hfov, double vfov) {
        CameraPinhole intrinsic = new CameraPinhole();
        intrinsic.width = width;
        intrinsic.height = height;
        intrinsic.cx = width / 2;
        intrinsic.cy = height / 2;
        intrinsic.fx = intrinsic.cx / Math.tan(UtilAngle.degreeToRadian((double)(hfov / 2.0)));
        intrinsic.fy = intrinsic.cy / Math.tan(UtilAngle.degreeToRadian((double)(vfov / 2.0)));
        return intrinsic;
    }

    public static CameraPinholeRadial createIntrinsic(int width, int height, double hfov) {
        CameraPinholeRadial intrinsic = new CameraPinholeRadial();
        intrinsic.width = width;
        intrinsic.height = height;
        intrinsic.cx = width / 2;
        intrinsic.cy = height / 2;
        intrinsic.fy = intrinsic.fx = intrinsic.cx / Math.tan(UtilAngle.degreeToRadian((double)(hfov / 2.0)));
        return intrinsic;
    }

    public static void scaleIntrinsic(CameraPinhole param, double scale) {
        param.width = (int)((double)param.width * scale);
        param.height = (int)((double)param.height * scale);
        param.cx *= scale;
        param.cy *= scale;
        param.fx *= scale;
        param.fy *= scale;
        param.skew *= scale;
    }

    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, DMatrixRMaj adjustMatrix, C adjustedParam) {
        return ImplPerspectiveOps_F64.adjustIntrinsic(parameters, adjustMatrix, adjustedParam);
    }

    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, FMatrixRMaj adjustMatrix, C adjustedParam) {
        return ImplPerspectiveOps_F32.adjustIntrinsic(parameters, adjustMatrix, adjustedParam);
    }

    public static DMatrixRMaj calibrationMatrix(double fx, double fy, double skew, double xc, double yc) {
        return ImplPerspectiveOps_F64.calibrationMatrix(fx, fy, skew, xc, yc);
    }

    public static FMatrixRMaj calibrationMatrix(float fx, float fy, float skew, float xc, float yc) {
        return ImplPerspectiveOps_F32.calibrationMatrix(fx, fy, skew, xc, yc);
    }

    public static DMatrixRMaj calibrationMatrix(CameraPinhole param, DMatrixRMaj K) {
        return ImplPerspectiveOps_F64.calibrationMatrix(param, K);
    }

    public static FMatrixRMaj calibrationMatrix(CameraPinhole param, FMatrixRMaj K) {
        return ImplPerspectiveOps_F32.calibrationMatrix(param, K);
    }

    public static <C extends CameraPinhole> C matrixToParam(DMatrixRMaj K, int width, int height, C param) {
        return ImplPerspectiveOps_F64.matrixToParam(K, width, height, param);
    }

    public static <C extends CameraPinhole> C matrixToParam(FMatrixRMaj K, int width, int height, C param) {
        return ImplPerspectiveOps_F32.matrixToParam(K, width, height, param);
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, double x, double y, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.convertNormToPixel(param, x, y, pixel);
    }

    public static Point2D_F32 convertNormToPixel(CameraModel param, float x, float y, Point2D_F32 pixel) {
        return ImplPerspectiveOps_F32.convertNormToPixel(param, x, y, pixel);
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, Point2D_F64 norm, Point2D_F64 pixel) {
        return PerspectiveOps.convertNormToPixel(param, norm.x, norm.y, pixel);
    }

    public static Point2D_F64 convertNormToPixel(DMatrixRMaj K, Point2D_F64 norm, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.convertNormToPixel(K, norm, pixel);
    }

    public static Point2D_F64 convertPixelToNorm(CameraModel param, Point2D_F64 pixel, Point2D_F64 norm) {
        return ImplPerspectiveOps_F64.convertPixelToNorm(param, pixel, norm);
    }

    public static Point2D_F32 convertPixelToNorm(CameraModel param, Point2D_F32 pixel, Point2D_F32 norm) {
        return ImplPerspectiveOps_F32.convertPixelToNorm(param, pixel, norm);
    }

    public static Point2D_F64 convertPixelToNorm(DMatrixRMaj K, Point2D_F64 pixel, Point2D_F64 norm) {
        return ImplPerspectiveOps_F64.convertPixelToNorm(K, pixel, norm);
    }

    public static Point2D_F32 convertPixelToNorm(FMatrixRMaj K, Point2D_F32 pixel, Point2D_F32 norm) {
        return ImplPerspectiveOps_F32.convertPixelToNorm(K, pixel, norm);
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, DMatrixRMaj K, Point3D_F64 X) {
        return ImplPerspectiveOps_F64.renderPixel(worldToCamera, K, X);
    }

    public static Point2D_F64 renderPixel(CameraPinhole intrinsic, Point3D_F64 X) {
        Point2D_F64 norm = new Point2D_F64(X.x / X.z, X.y / X.z);
        return PerspectiveOps.convertNormToPixel(intrinsic, norm, norm);
    }

    public static Point2D_F64 renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X) {
        return ImplPerspectiveOps_F64.renderPixel(worldToCamera, X);
    }

    public static void splitAssociated(List<AssociatedPair> pairs, List<Point2D_F64> view1, List<Point2D_F64> view2) {
        for (AssociatedPair p : pairs) {
            view1.add(p.p1);
            view2.add(p.p2);
        }
    }

    public static void splitAssociated(List<AssociatedTriple> pairs, List<Point2D_F64> view1, List<Point2D_F64> view2, List<Point2D_F64> view3) {
        for (AssociatedTriple p : pairs) {
            view1.add(p.p1);
            view2.add(p.p2);
            view3.add(p.p3);
        }
    }

    public static DMatrixRMaj createCameraMatrix(DMatrixRMaj R, Vector3D_F64 T, DMatrixRMaj K, DMatrixRMaj ret) {
        return ImplPerspectiveOps_F64.createCameraMatrix(R, T, K, ret);
    }

    public static WorldToCameraToPixel createWorldToPixel(CameraPinholeRadial intrinsic, Se3_F64 worldToCamera) {
        WorldToCameraToPixel alg = new WorldToCameraToPixel();
        alg.configure(intrinsic, worldToCamera);
        return alg;
    }

    public static WorldToCameraToPixel createWorldToPixel(LensDistortionNarrowFOV distortion, Se3_F64 worldToCamera) {
        WorldToCameraToPixel alg = new WorldToCameraToPixel();
        alg.configure(distortion, worldToCamera);
        return alg;
    }
}

