/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.f.FundamentalLinear;
import boofcv.struct.geo.AssociatedPair;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.PolynomialSolver;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.SpecializedOps_DDRM;

public class FundamentalLinear7
extends FundamentalLinear {
    protected DMatrixRMaj F1 = new DMatrixRMaj(3, 3);
    protected DMatrixRMaj F2 = new DMatrixRMaj(3, 3);
    private DMatrixRMaj nullspace = new DMatrixRMaj(1, 1);
    private Polynomial poly = new Polynomial(4);
    private PolynomialRoots rootFinder = PolynomialSolver.createRootFinder((RootFinderType)RootFinderType.EVD, (int)4);

    public FundamentalLinear7(boolean computeFundamental) {
        super(computeFundamental);
    }

    public boolean process(List<AssociatedPair> points, FastQueue<DMatrixRMaj> solutions) {
        if (points.size() != 7) {
            throw new IllegalArgumentException("Must be exactly 7 points. Not " + points.size() + " you gelatinous piece of pond scum.");
        }
        solutions.reset();
        LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
        this.createA(points, this.A);
        if (!this.process(this.A)) {
            return false;
        }
        this.undoNormalizationF(this.F1, this.N1.matrix(), this.N2.matrix());
        this.undoNormalizationF(this.F2, this.N1.matrix(), this.N2.matrix());
        FundamentalLinear7.computeCoefficients(this.F1, this.F2, this.poly.c);
        this.computeSolutions(solutions);
        return true;
    }

    private boolean process(DMatrixRMaj A) {
        if (!this.solverNull.process((Matrix)A, 2, (Matrix)this.nullspace)) {
            return false;
        }
        SpecializedOps_DDRM.subvector((DMatrix1Row)this.nullspace, (int)0, (int)0, (int)9, (boolean)false, (int)0, (DMatrix1Row)this.F1);
        SpecializedOps_DDRM.subvector((DMatrix1Row)this.nullspace, (int)0, (int)1, (int)9, (boolean)false, (int)0, (DMatrix1Row)this.F2);
        return true;
    }

    public void computeSolutions(FastQueue<DMatrixRMaj> solutions) {
        if (!this.rootFinder.process(this.poly)) {
            return;
        }
        List zeros = this.rootFinder.getRoots();
        for (Complex_F64 c : zeros) {
            if (!c.isReal() && Math.abs(c.imaginary) > 1.0E-10) continue;
            DMatrixRMaj F = (DMatrixRMaj)solutions.grow();
            double a = c.real;
            double b = 1.0 - c.real;
            for (int i = 0; i < 9; ++i) {
                F.data[i] = a * this.F1.data[i] + b * this.F2.data[i];
            }
            if (this.computeFundamental || this.projectOntoEssential(F)) continue;
            solutions.removeTail();
        }
    }

    public static void computeCoefficients(DMatrixRMaj F1, DMatrixRMaj F2, double[] coefs) {
        Arrays.fill(coefs, 0.0);
        FundamentalLinear7.computeCoefficients(F1, F2, 0, 4, 8, coefs, false);
        FundamentalLinear7.computeCoefficients(F1, F2, 1, 5, 6, coefs, false);
        FundamentalLinear7.computeCoefficients(F1, F2, 2, 3, 7, coefs, false);
        FundamentalLinear7.computeCoefficients(F1, F2, 2, 4, 6, coefs, true);
        FundamentalLinear7.computeCoefficients(F1, F2, 1, 3, 8, coefs, true);
        FundamentalLinear7.computeCoefficients(F1, F2, 0, 5, 7, coefs, true);
    }

    public static void computeCoefficients(DMatrixRMaj F1, DMatrixRMaj F2, int i, int j, int k, double[] coefs, boolean minus) {
        if (minus) {
            FundamentalLinear7.computeCoefficientsMinus(F1.data[i], F1.data[j], F1.data[k], F2.data[i], F2.data[j], F2.data[k], coefs);
        } else {
            FundamentalLinear7.computeCoefficients(F1.data[i], F1.data[j], F1.data[k], F2.data[i], F2.data[j], F2.data[k], coefs);
        }
    }

    public static void computeCoefficients(double x1, double y1, double z1, double x2, double y2, double z2, double[] coefs) {
        coefs[3] = coefs[3] + (x1 * (y1 * (z1 - z2) + y2 * (z2 - z1)) + x2 * (y1 * (z2 - z1) + y2 * (z1 - z2)));
        coefs[2] = coefs[2] + (x1 * (y1 * z2 + y2 * (z1 - 2.0 * z2)) + x2 * (y1 * (z1 - 2.0 * z2) + y2 * (3.0 * z2 - 2.0 * z1)));
        coefs[1] = coefs[1] + (x1 * y2 * z2 + x2 * (y1 * z2 + y2 * (z1 - 3.0 * z2)));
        coefs[0] = coefs[0] + x2 * y2 * z2;
    }

    public static void computeCoefficientsMinus(double x1, double y1, double z1, double x2, double y2, double z2, double[] coefs) {
        coefs[3] = coefs[3] - (x1 * (y1 * (z1 - z2) + y2 * (z2 - z1)) + x2 * (y1 * (z2 - z1) + y2 * (z1 - z2)));
        coefs[2] = coefs[2] - (x1 * (y1 * z2 + y2 * (z1 - 2.0 * z2)) + x2 * (y1 * (z1 - 2.0 * z2) + y2 * (3.0 * z2 - 2.0 * z1)));
        coefs[1] = coefs[1] - (x1 * y2 * z2 + x2 * (y1 * z2 + y2 * (z1 - 3.0 * z2)));
        coefs[0] = coefs[0] - x2 * y2 * z2;
    }
}

