/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.tracker.DdaFeatureManager;
import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectDescribeAssociate<I extends ImageGray<I>, Desc extends TupleDesc>
implements PointTracker<I> {
    protected AssociateDescription2D<Desc> associate;
    protected DdaFeatureManager<I, Desc> manager;
    protected SetTrackInfo[] sets;
    protected List<PointTrack> tracksAll = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksActive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksInactive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksDropped = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksNew = new ArrayList<PointTrack>();
    protected List<PointTrack> unused = new ArrayList<PointTrack>();
    protected long featureID = 0L;
    boolean updateDescription;

    public DetectDescribeAssociate(DdaFeatureManager<I, Desc> manager, AssociateDescription2D<Desc> associate, boolean updateDescription) {
        this.manager = manager;
        this.associate = associate;
        this.updateDescription = updateDescription;
        this.sets = new SetTrackInfo[manager.getNumberOfSets()];
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i] = new SetTrackInfo();
            this.sets[i].featSrc = new FastQueue(10, manager.getDescriptionType(), false);
            this.sets[i].featDst = new FastQueue(10, manager.getDescriptionType(), false);
        }
    }

    protected DetectDescribeAssociate() {
    }

    public boolean isUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(boolean updateDescription) {
        this.updateDescription = updateDescription;
    }

    @Override
    public void reset() {
        this.dropAllTracks();
        this.featureID = 0L;
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i].featDst.reset();
            this.sets[i].locDst.reset();
            this.sets[i].matches.reset();
        }
    }

    @Override
    public void process(I input) {
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksDropped.clear();
        this.tracksNew.clear();
        this.manager.detectFeatures(input);
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            int j;
            SetTrackInfo info = this.sets[setIndex];
            info.featDst.reset();
            info.locDst.reset();
            this.manager.getFeatures(setIndex, info.locDst, info.featDst);
            if (info.tracks.isEmpty()) continue;
            this.performTracking(info);
            for (j = 0; j < info.tracks.size(); ++j) {
                if (info.isAssociated[j]) continue;
                this.tracksInactive.add(info.tracks.get(j));
            }
            for (j = 0; j < this.sets.length; ++j) {
                this.sets[j].featSrc.reset();
                this.sets[j].locSrc.reset();
            }
        }
    }

    protected void performTracking(SetTrackInfo<Desc> info) {
        this.putIntoSrcList(info);
        this.associate.setSource(info.locSrc, info.featSrc);
        this.associate.setDestination(info.locDst, info.featDst);
        this.associate.associate();
        FastQueue matches = this.associate.getMatches();
        info.matches.resize(matches.size);
        for (int i = 0; i < matches.size; ++i) {
            ((AssociatedIndex)info.matches.get(i)).set((AssociatedIndex)matches.get(i));
        }
        this.updateTrackState(info);
    }

    protected void putIntoSrcList(SetTrackInfo<Desc> info) {
        if (info.isAssociated.length < info.tracks.size()) {
            info.isAssociated = new boolean[info.tracks.size()];
        }
        info.featSrc.reset();
        info.locSrc.reset();
        for (int i = 0; i < info.tracks.size(); ++i) {
            PointTrack t = info.tracks.get(i);
            TupleDesc desc = (TupleDesc)t.getDescription();
            info.featSrc.add((Object)desc);
            info.locSrc.add((Object)t);
            info.isAssociated[i] = false;
        }
    }

    protected void updateTrackState(SetTrackInfo<Desc> info) {
        for (int i = 0; i < info.matches.size; ++i) {
            AssociatedIndex indexes = ((AssociatedIndex[])info.matches.data)[i];
            PointTrack track = info.tracks.get(indexes.src);
            Point2D_F64 loc = ((Point2D_F64[])info.locDst.data)[indexes.dst];
            track.set(loc.x, loc.y);
            this.tracksActive.add(track);
            if (this.updateDescription) {
                ((TupleDesc)track.getDescription()).setTo((TupleDesc)info.featDst.get(indexes.dst));
            }
            info.isAssociated[indexes.src] = true;
        }
    }

    @Override
    public void spawnTracks() {
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            int i;
            SetTrackInfo info = this.sets[setIndex];
            if (info.isAssociated.length < info.featDst.size) {
                info.isAssociated = new boolean[info.featDst.size];
            }
            for (i = 0; i < info.featDst.size; ++i) {
                info.isAssociated[i] = false;
            }
            for (i = 0; i < info.matches.size; ++i) {
                info.isAssociated[((AssociatedIndex[])info.matches.data)[i].dst] = true;
            }
            for (i = 0; i < info.featDst.size; ++i) {
                if (info.isAssociated[i]) continue;
                Point2D_F64 loc = (Point2D_F64)info.locDst.get(i);
                this.addNewTrack(setIndex, loc.x, loc.y, (TupleDesc)info.featDst.get(i));
            }
        }
    }

    protected PointTrack addNewTrack(int setIndex, double x, double y, Desc desc) {
        PointTrack p = this.getUnused();
        p.set(x, y);
        ((TupleDesc)p.getDescription()).setTo(desc);
        if (this.checkValidSpawn(setIndex, p)) {
            p.setId = setIndex;
            p.featureId = this.featureID++;
            this.sets[setIndex].tracks.add(p);
            this.tracksNew.add(p);
            this.tracksActive.add(p);
            this.tracksAll.add(p);
            return p;
        }
        this.unused.add(p);
        return null;
    }

    protected boolean checkValidSpawn(int setIndex, PointTrack p) {
        return true;
    }

    protected PointTrack getUnused() {
        PointTrack p;
        if (this.unused.size() > 0) {
            p = this.unused.remove(this.unused.size() - 1);
        } else {
            p = new PointTrack();
            p.setDescription(this.manager.createDescription());
        }
        return p;
    }

    @Override
    public void dropAllTracks() {
        this.unused.addAll(this.tracksAll);
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksAll.clear();
        this.tracksNew.clear();
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            SetTrackInfo info = this.sets[setIndex];
            info.tracks.clear();
        }
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (!this.tracksAll.remove((Object)track)) {
            return false;
        }
        if (!this.sets[track.setId].tracks.remove((Object)track)) {
            return false;
        }
        this.tracksActive.remove((Object)track);
        this.tracksInactive.remove((Object)track);
        this.unused.add(track);
        return true;
    }

    @Override
    public List<PointTrack> getActiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksActive);
        return list;
    }

    @Override
    public List<PointTrack> getDroppedTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksDropped);
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksNew);
        return list;
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksAll);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksInactive);
        return list;
    }

    protected static class SetTrackInfo<Desc> {
        protected FastQueue<Point2D_F64> locDst = new FastQueue(10, Point2D_F64.class, false);
        protected FastQueue<Point2D_F64> locSrc = new FastQueue(10, Point2D_F64.class, true);
        protected FastQueue<Desc> featSrc;
        protected FastQueue<Desc> featDst;
        protected boolean[] isAssociated = new boolean[1];
        protected List<PointTrack> tracks = new ArrayList<PointTrack>();
        protected FastQueue<AssociatedIndex> matches = new FastQueue(AssociatedIndex.class, true);

        protected SetTrackInfo() {
        }
    }
}

