/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.GrowQueue_F32;
import org.ddogleg.struct.GrowQueue_I32;

public class SceneObservations {
    public View[] views;

    public SceneObservations(int numViews) {
        this.views = new View[numViews];
        for (int i = 0; i < numViews; ++i) {
            this.views[i] = new View();
        }
    }

    public int getObservationCount() {
        int total = 0;
        for (int i = 0; i < this.views.length; ++i) {
            total += this.views[i].point.size;
        }
        return total;
    }

    public View getView(int which) {
        return this.views[which];
    }

    public void checkOneObservationPerView() {
        for (int viewIdx = 0; viewIdx < this.views.length; ++viewIdx) {
            View v = this.views[viewIdx];
            for (int obsIdx = 0; obsIdx < v.size(); ++obsIdx) {
                int a = v.point.get(obsIdx);
                for (int i = obsIdx + 1; i < v.size(); ++i) {
                    if (a != v.point.get(i)) continue;
                    new RuntimeException("Same point is viewed more than once in the same view");
                }
            }
        }
    }

    public static class View {
        public GrowQueue_I32 point = new GrowQueue_I32();
        public GrowQueue_F32 observations = new GrowQueue_F32();

        public int size() {
            return this.point.size;
        }

        public void remove(int index) {
            this.point.remove(index);
            this.observations.remove(index *= 2, index + 1);
        }

        public void set(int index, float x, float y) {
            this.observations.data[index *= 2] = x;
            this.observations.data[index + 1] = y;
        }

        public int getPointId(int index) {
            return this.point.get(index);
        }

        public void get(int index, Point2D_F64 p) {
            if (index >= this.point.size) {
                throw new IndexOutOfBoundsException(index + " >= " + this.point.size);
            }
            p.x = this.observations.data[index *= 2];
            p.y = this.observations.data[index + 1];
        }

        public void get(int index, PointIndex2D_F64 observation) {
            if (index >= this.point.size) {
                throw new IndexOutOfBoundsException(index + " >= " + this.point.size);
            }
            observation.index = this.point.data[index];
            observation.set(this.observations.data[index *= 2], this.observations.data[index + 1]);
        }

        public void add(int featureIndex, float x, float y) {
            this.point.add(featureIndex);
            this.observations.add(x);
            this.observations.add(y);
        }

        public void checkDuplicatePoints() {
            for (int i = 0; i < this.point.size; ++i) {
                int pa = this.point.get(i);
                for (int j = i + 1; j < this.point.size; ++j) {
                    if (pa != this.point.get(j)) continue;
                    throw new RuntimeException("Duplicates");
                }
            }
        }
    }
}

