/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneStructure;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class SceneStructureCommon
implements SceneStructure {
    public Point[] points;
    public boolean homogenous;
    protected int pointSize;

    public SceneStructureCommon(boolean homogenous) {
        this.homogenous = homogenous;
        this.pointSize = homogenous ? 4 : 3;
    }

    public void setPoint(int which, double x, double y, double z) {
        this.points[which].set(x, y, z);
    }

    public void setPoint(int which, double x, double y, double z, double w) {
        this.points[which].set(x, y, z, w);
    }

    public void connectPointToView(int pointIndex, int viewIndex) {
        Point p = this.points[pointIndex];
        for (int i = 0; i < p.views.size; ++i) {
            if (p.views.data[i] != viewIndex) continue;
            throw new IllegalArgumentException("Tried to add the same view twice. viewIndex=" + viewIndex);
        }
        p.views.add(viewIndex);
    }

    public Point[] getPoints() {
        return this.points;
    }

    public void removePoints(GrowQueue_I32 which) {
        Point[] results = new Point[this.points.length - which.size];
        int indexWhich = 0;
        for (int i = 0; i < this.points.length; ++i) {
            if (indexWhich < which.size && which.data[indexWhich] == i) {
                ++indexWhich;
                continue;
            }
            results[i - indexWhich] = this.points[i];
        }
        this.points = results;
    }

    @Override
    public boolean isHomogenous() {
        return this.homogenous;
    }

    public int getObservationCount() {
        int total = 0;
        for (int i = 0; i < this.points.length; ++i) {
            total += this.points[i].views.size;
        }
        return total;
    }

    public static class Point {
        public double[] coordinate;
        public GrowQueue_I32 views = new GrowQueue_I32();

        public Point(int dof) {
            this.coordinate = new double[dof];
        }

        public void removeView(int which) {
            int index = this.views.indexOf(which);
            if (index == -1) {
                throw new RuntimeException("BUG. Could not find in list of views. which=" + which);
            }
            this.views.remove(index);
        }

        public void set(double x, double y, double z) {
            this.coordinate[0] = x;
            this.coordinate[1] = y;
            this.coordinate[2] = z;
        }

        public void set(double x, double y, double z, double w) {
            this.coordinate[0] = x;
            this.coordinate[1] = y;
            this.coordinate[2] = z;
            this.coordinate[3] = w;
        }

        public void get(Point3D_F64 p) {
            p.x = this.coordinate[0];
            p.y = this.coordinate[1];
            p.z = this.coordinate[2];
        }

        public void get(Point4D_F64 p) {
            p.x = this.coordinate[0];
            p.y = this.coordinate[1];
            p.z = this.coordinate[2];
            p.w = this.coordinate[3];
        }

        public double getX() {
            return this.coordinate[0];
        }

        public double getY() {
            return this.coordinate[1];
        }

        public double getZ() {
            return this.coordinate[2];
        }

        public double getW() {
            return this.coordinate[3];
        }

        public double distanceSq(Point3D_F64 p) {
            double dx = this.coordinate[0] - p.x;
            double dy = this.coordinate[1] - p.y;
            double dz = this.coordinate[2] - p.z;
            return dx * dx + dy * dy + dz * dz;
        }

        public void normalizeH() {
            double n = 0.0;
            n += this.coordinate[0] * this.coordinate[0];
            n += this.coordinate[1] * this.coordinate[1];
            n += this.coordinate[2] * this.coordinate[2];
            n += this.coordinate[3] * this.coordinate[3];
            n = Math.sqrt(n);
            this.coordinate[0] = this.coordinate[0] / n;
            this.coordinate[1] = this.coordinate[1] / n;
            this.coordinate[2] = this.coordinate[2] / n;
            this.coordinate[3] = this.coordinate[3] / n;
        }

        public double distance(Point3D_F64 p) {
            return Math.sqrt(this.distance(p));
        }

        public double distance(Point p) {
            double dx = this.coordinate[0] - p.coordinate[0];
            double dy = this.coordinate[1] - p.coordinate[1];
            double dz = this.coordinate[2] - p.coordinate[2];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
    }
}

