/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.alg.geo.bundle.cameras.BundlePinhole;
import boofcv.alg.geo.bundle.cameras.BundlePinholeRadial;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import georegression.struct.se.Se3_F64;

public class SceneStructureMetric
extends SceneStructureCommon {
    public Camera[] cameras;
    public View[] views;

    public SceneStructureMetric(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints) {
        int i;
        this.cameras = new Camera[totalCameras];
        this.views = new View[totalViews];
        this.points = new SceneStructureCommon.Point[totalPoints];
        for (i = 0; i < this.cameras.length; ++i) {
            this.cameras[i] = new Camera();
        }
        for (i = 0; i < this.views.length; ++i) {
            this.views[i] = new View();
        }
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new SceneStructureCommon.Point(this.pointSize);
        }
    }

    public void setCamera(int which, boolean fixed, BundleAdjustmentCamera model) {
        this.cameras[which].known = fixed;
        this.cameras[which].model = model;
    }

    public void setCamera(int which, boolean fixed, CameraPinhole intrinsic) {
        this.setCamera(which, fixed, new BundlePinhole(intrinsic));
    }

    public void setCamera(int which, boolean fixed, CameraPinholeRadial intrinsic) {
        this.setCamera(which, fixed, new BundlePinholeRadial(intrinsic));
    }

    public void setView(int which, boolean fixed, Se3_F64 worldToView) {
        this.views[which].known = fixed;
        this.views[which].worldToView.set(worldToView);
    }

    public void connectViewToCamera(int viewIndex, int cameraIndex) {
        if (this.views[viewIndex].camera != -1) {
            throw new RuntimeException("View has already been assigned a camera");
        }
        this.views[viewIndex].camera = cameraIndex;
    }

    public int getUnknownCameraCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.length; ++i) {
            if (this.cameras[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownViewCount() {
        int total = 0;
        for (int i = 0; i < this.views.length; ++i) {
            if (this.views[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownCameraParameterCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.length; ++i) {
            if (this.cameras[i].known) continue;
            total += this.cameras[i].model.getIntrinsicCount();
        }
        return total;
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownViewCount() * 6 + this.points.length * this.pointSize + this.getUnknownCameraParameterCount();
    }

    public Camera[] getCameras() {
        return this.cameras;
    }

    public View[] getViews() {
        return this.views;
    }

    public static class View {
        public boolean known = true;
        public Se3_F64 worldToView = new Se3_F64();
        public int camera = -1;
    }

    public static class Camera {
        public boolean known = true;
        public BundleAdjustmentCamera model;

        public <T extends BundleAdjustmentCamera> T getModel() {
            return (T)this.model;
        }
    }
}

