/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;

public class SceneStructureProjective
extends SceneStructureCommon {
    public View[] views;

    public SceneStructureProjective(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalViews, int totalPoints) {
        int i;
        this.views = new View[totalViews];
        this.points = new SceneStructureCommon.Point[totalPoints];
        for (i = 0; i < this.views.length; ++i) {
            this.views[i] = new View();
        }
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new SceneStructureCommon.Point(this.pointSize);
        }
    }

    public void setView(int which, boolean fixed, DMatrixRMaj worldToView, int width, int height) {
        this.views[which].known = fixed;
        this.views[which].worldToView.set((DMatrixD1)worldToView);
        this.views[which].width = width;
        this.views[which].height = height;
    }

    public int getUnknownViewCount() {
        int total = 0;
        for (int i = 0; i < this.views.length; ++i) {
            if (this.views[i].known) continue;
            ++total;
        }
        return total;
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownViewCount() * 12 + this.points.length * this.pointSize;
    }

    public View[] getViews() {
        return this.views;
    }

    public static class View {
        public boolean known = true;
        public int width;
        public int height;
        public DMatrixRMaj worldToView = new DMatrixRMaj(3, 4);
    }
}

