/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;

public class NormalizationPoint2D {
    public double meanX = 0.0;
    public double stdX = 1.0;
    public double meanY = 0.0;
    public double stdY = 1.0;

    public NormalizationPoint2D() {
    }

    public NormalizationPoint2D(double meanX, double stdX, double meanY, double stdY) {
        this.meanX = meanX;
        this.stdX = stdX;
        this.meanY = meanY;
        this.stdY = stdY;
    }

    public void set(double meanX, double stdX, double meanY, double stdY) {
        this.meanX = meanX;
        this.stdX = stdX;
        this.meanY = meanY;
        this.stdY = stdY;
    }

    public void apply(DMatrixRMaj H, DMatrixRMaj output) {
        output.reshape(3, H.numCols);
        int stride = H.numCols;
        for (int col = 0; col < H.numCols; ++col) {
            double h1 = H.data[col];
            double h2 = H.data[col + stride];
            double h3 = H.data[col + 2 * stride];
            output.data[col] = h1 / this.stdX - this.meanX * h3 / this.stdX;
            output.data[col + stride] = h2 / this.stdY - this.meanY * h3 / this.stdY;
            output.data[col + 2 * stride] = h3;
        }
    }

    public void remove(DMatrixRMaj H, DMatrixRMaj output) {
        output.reshape(3, H.numCols);
        int stride = H.numCols;
        for (int col = 0; col < H.numCols; ++col) {
            double h1 = H.data[col];
            double h2 = H.data[col + stride];
            double h3 = H.data[col + 2 * stride];
            output.data[col] = h1 * this.stdX + h3 * this.meanX;
            output.data[col + stride] = h2 * this.stdY + h3 * this.meanY;
            output.data[col + 2 * stride] = h3;
        }
    }

    public void apply(Point2D_F64 p) {
        p.x = (p.x - this.meanX) / this.stdX;
        p.y = (p.y - this.meanY) / this.stdY;
    }

    public void apply(Point3D_F64 p) {
        p.x = (p.x - p.z * this.meanX) / this.stdX;
        p.y = (p.y - p.z * this.meanY) / this.stdY;
    }

    public void apply(Point2D_F64 input, Point2D_F64 output) {
        output.x = (input.x - this.meanX) / this.stdX;
        output.y = (input.y - this.meanY) / this.stdY;
    }

    public void remove(Point2D_F64 p) {
        p.x = p.x * this.stdX + this.meanX;
        p.y = p.y * this.stdY + this.meanY;
    }

    public void remove(Point2D_F64 input, Point2D_F64 output) {
        output.x = input.x * this.stdX + this.meanX;
        output.y = input.y * this.stdY + this.meanY;
    }

    public void remove(Point3D_F64 p) {
        p.x = p.x * this.stdX + p.z * this.meanX;
        p.y = p.y * this.stdY + p.z * this.meanY;
    }

    public DMatrixRMaj matrix() {
        DMatrixRMaj M = new DMatrixRMaj(3, 3);
        M.set(0, 0, 1.0 / this.stdX);
        M.set(1, 1, 1.0 / this.stdY);
        M.set(0, 2, -this.meanX / this.stdX);
        M.set(1, 2, -this.meanY / this.stdY);
        M.set(2, 2, 1.0);
        return M;
    }

    public DMatrixRMaj matrixInv() {
        DMatrixRMaj M = new DMatrixRMaj(3, 3);
        M.set(0, 0, this.stdX);
        M.set(1, 1, this.stdY);
        M.set(0, 2, this.meanX);
        M.set(1, 2, this.meanY);
        M.set(2, 2, 1.0);
        return M;
    }

    public boolean isEquals(NormalizationPoint2D a, double tol) {
        if (Math.abs(a.meanX - this.meanX) > tol) {
            return false;
        }
        if (Math.abs(a.meanY - this.meanY) > tol) {
            return false;
        }
        if (Math.abs(a.stdX - this.stdX) > tol) {
            return false;
        }
        return !(Math.abs(a.stdY - this.stdY) > tol);
    }
}

