/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DSCC;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class BundleAdjustmentMetricResidualFunction
implements BundleAdjustmentSchur_DSCC.FunctionResiduals<SceneStructureMetric> {
    private SceneStructureMetric structure;
    private SceneObservations observations;
    private Point3D_F64 worldPt = new Point3D_F64();
    private int numParameters;
    private int numObservations;
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2D_F64 predictedPixel = new Point2D_F64();
    private PointIndex2D_F64 observedPixel = new PointIndex2D_F64();
    CodecSceneStructureMetric codec = new CodecSceneStructureMetric();
    Point3D_F64 p3 = new Point3D_F64();

    @Override
    public void configure(SceneStructureMetric structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        this.numObservations = observations.getObservationCount();
        this.numParameters = structure.getParameterCount();
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.numObservations * 2;
    }

    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.structure);
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.length; ++viewIndex) {
            SceneStructureMetric.View view = this.structure.views[viewIndex];
            SceneStructureMetric.Camera camera = this.structure.cameras[view.camera];
            SceneObservations.View obsView = this.observations.views[viewIndex];
            for (int i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = this.structure.points[this.observedPixel.index];
                worldPt.get(this.p3);
                SePointOps_F64.transform((Se3_F64)view.worldToView, (Point3D_F64)this.p3, (Point3D_F64)this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
        }
    }
}

