/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DSCC;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.RodriguesRotationJacobian;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.DMatrixSparseTriplet;
import org.ejml.ops.ConvertDMatrixStruct;

public class BundleAdjustmentMetricSchurJacobian_DSCC
implements BundleAdjustmentSchur_DSCC.Jacobian<SceneStructureMetric> {
    private SceneStructureMetric structure;
    private SceneObservations observations;
    private int numViewsUnknown;
    private int numParameters;
    private RodriguesRotationJacobian rodJacobian = new RodriguesRotationJacobian();
    private Se3_F64 worldToView = new Se3_F64();
    private Rodrigues_F64 rodrigues = new Rodrigues_F64();
    private Point3D_F64 worldPt = new Point3D_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private int indexFirstView;
    private int indexLastView;
    private int[] viewParameterIndexes;
    private int[] cameraParameterIndexes;
    private int jacRowX;
    private int jacRowY;
    private DMatrixSparseTriplet tripletPoint = new DMatrixSparseTriplet();
    private DMatrixSparseTriplet tripletView = new DMatrixSparseTriplet();
    private double[] pointGradX = new double[3];
    private double[] pointGradY = new double[3];
    private double[] calibGradX = null;
    private double[] calibGradY = null;

    @Override
    public void configure(SceneStructureMetric structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        this.numViewsUnknown = structure.getUnknownViewCount();
        int numCameraParameters = structure.getUnknownCameraParameterCount();
        this.indexFirstView = structure.points.length * 3;
        this.indexLastView = this.indexFirstView + this.numViewsUnknown * 6;
        this.numParameters = this.indexLastView + numCameraParameters;
        this.viewParameterIndexes = new int[structure.views.length];
        int index = 0;
        for (int i = 0; i < structure.views.length; ++i) {
            this.viewParameterIndexes[i] = index;
            if (structure.views[i].known) continue;
            index += 6;
        }
        this.cameraParameterIndexes = new int[structure.cameras.length];
        index = 0;
        int largestCameraSize = 0;
        for (int i = 0; i < structure.cameras.length; ++i) {
            if (structure.cameras[i].known) continue;
            this.cameraParameterIndexes[i] = index;
            int count = structure.cameras[i].model.getIntrinsicCount();
            largestCameraSize = Math.max(largestCameraSize, count);
            index += count;
        }
        this.calibGradX = new double[largestCameraSize];
        this.calibGradY = new double[largestCameraSize];
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.observations.getObservationCount() * 2;
    }

    public void process(double[] input, DMatrixSparseCSC left, DMatrixSparseCSC right) {
        int numRows = this.getNumOfOutputsM();
        int numPointParam = this.structure.points.length * 3;
        int numViewParam = this.numParameters - numPointParam;
        this.tripletPoint.reshape(numRows, numPointParam);
        this.tripletView.reshape(numRows, numViewParam);
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.length; ++viewIndex) {
            SceneStructureMetric.View view = this.structure.views[viewIndex];
            SceneStructureMetric.Camera camera = this.structure.cameras[view.camera];
            if (!view.known) {
                int paramIndex = this.viewParameterIndexes[viewIndex] + this.indexFirstView;
                double rodX = input[paramIndex];
                double rodY = input[paramIndex + 1];
                double rodZ = input[paramIndex + 2];
                this.worldToView.T.x = input[paramIndex + 3];
                this.worldToView.T.y = input[paramIndex + 4];
                this.worldToView.T.z = input[paramIndex + 5];
                this.rodrigues.setParamVector(rodX, rodY, rodZ);
                this.rodJacobian.process(rodX, rodY, rodZ);
                ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)this.rodrigues, (DMatrixRMaj)this.worldToView.R);
            } else {
                this.worldToView.set(view.worldToView);
            }
            int cameraParamStartIndex = this.cameraParameterIndexes[view.camera];
            if (!camera.known) {
                camera.model.setIntrinsic(input, this.indexLastView + cameraParamStartIndex);
            }
            SceneObservations.View obsView = this.observations.views[viewIndex];
            for (int i = 0; i < obsView.size(); ++i) {
                int featureIndex = obsView.point.get(i);
                int columnOfPointInJac = featureIndex * 3;
                this.worldPt.x = input[columnOfPointInJac];
                this.worldPt.y = input[columnOfPointInJac + 1];
                this.worldPt.z = input[columnOfPointInJac + 2];
                SePointOps_F64.transform((Se3_F64)this.worldToView, (Point3D_F64)this.worldPt, (Point3D_F64)this.cameraPt);
                this.jacRowX = observationIndex * 2;
                this.jacRowY = this.jacRowX + 1;
                if (!camera.known) {
                    int N = camera.model.getIntrinsicCount();
                    camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, true, this.calibGradX, this.calibGradY);
                    int location = this.indexLastView - this.indexFirstView + cameraParamStartIndex;
                    for (int j = 0; j < N; ++j) {
                        this.tripletView.addItemCheck(this.jacRowX, location + j, this.calibGradX[j]);
                        this.tripletView.addItemCheck(this.jacRowY, location + j, this.calibGradY[j]);
                    }
                } else {
                    camera.model.jacobian(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.pointGradX, this.pointGradY, false, null, null);
                }
                this.addToJacobian(this.tripletPoint, columnOfPointInJac, this.pointGradX, this.pointGradY, this.worldToView.R);
                if (!view.known) {
                    int col = this.viewParameterIndexes[viewIndex];
                    this.addToJacobian(this.tripletView, col + 0, this.pointGradX, this.pointGradY, this.rodJacobian.Rx, this.worldPt);
                    this.addToJacobian(this.tripletView, col + 1, this.pointGradX, this.pointGradY, this.rodJacobian.Ry, this.worldPt);
                    this.addToJacobian(this.tripletView, col + 2, this.pointGradX, this.pointGradY, this.rodJacobian.Rz, this.worldPt);
                    this.tripletView.addItemCheck(this.jacRowX, col + 3, this.pointGradX[0]);
                    this.tripletView.addItem(this.jacRowY, col + 3, this.pointGradY[0]);
                    this.tripletView.addItemCheck(this.jacRowX, col + 4, this.pointGradX[1]);
                    this.tripletView.addItem(this.jacRowY, col + 4, this.pointGradY[1]);
                    this.tripletView.addItemCheck(this.jacRowX, col + 5, this.pointGradX[2]);
                    this.tripletView.addItem(this.jacRowY, col + 5, this.pointGradY[2]);
                }
                ++observationIndex;
            }
        }
        ConvertDMatrixStruct.convert((DMatrixSparseTriplet)this.tripletPoint, (DMatrixSparseCSC)left);
        ConvertDMatrixStruct.convert((DMatrixSparseTriplet)this.tripletView, (DMatrixSparseCSC)right);
    }

    private void addToJacobian(DMatrixSparseTriplet tripplet, int col, double[] a, double[] b, DMatrixRMaj R) {
        tripplet.addItem(this.jacRowX, col + 0, a[0] * R.data[0] + a[1] * R.data[3] + a[2] * R.data[6]);
        tripplet.addItem(this.jacRowX, col + 1, a[0] * R.data[1] + a[1] * R.data[4] + a[2] * R.data[7]);
        tripplet.addItem(this.jacRowX, col + 2, a[0] * R.data[2] + a[1] * R.data[5] + a[2] * R.data[8]);
        tripplet.addItem(this.jacRowY, col + 0, b[0] * R.data[0] + b[1] * R.data[3] + b[2] * R.data[6]);
        tripplet.addItem(this.jacRowY, col + 1, b[0] * R.data[1] + b[1] * R.data[4] + b[2] * R.data[7]);
        tripplet.addItem(this.jacRowY, col + 2, b[0] * R.data[2] + b[1] * R.data[5] + b[2] * R.data[8]);
    }

    private void addToJacobian(DMatrixSparseTriplet tripplet, int col, double[] a, double[] b, DMatrixRMaj R, Point3D_F64 X) {
        double x = R.data[0] * X.x + R.data[1] * X.y + R.data[2] * X.z;
        double y = R.data[3] * X.x + R.data[4] * X.y + R.data[5] * X.z;
        double z = R.data[6] * X.x + R.data[7] * X.y + R.data[8] * X.z;
        tripplet.addItem(this.jacRowX, col, a[0] * x + a[1] * y + a[2] * z);
        tripplet.addItem(this.jacRowY, col, b[0] * x + b[1] * y + b[2] * z);
    }
}

