/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DSCC;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.data.DMatrixRMaj;

public class CodecSceneStructureMetric
implements BundleAdjustmentSchur_DSCC.Codec<SceneStructureMetric> {
    private Rodrigues_F64 rodrigues = new Rodrigues_F64();

    @Override
    public void decode(double[] input, SceneStructureMetric structure) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.length; ++i) {
            SceneStructureCommon.Point p = structure.points[i];
            p.coordinate[0] = input[index++];
            p.coordinate[1] = input[index++];
            p.coordinate[2] = input[index++];
            if (!structure.isHomogenous()) continue;
            p.coordinate[3] = input[index++];
        }
        for (int viewIndex = 0; viewIndex < structure.views.length; ++viewIndex) {
            SceneStructureMetric.View view = structure.views[viewIndex];
            if (view.known) continue;
            double rodX = input[index++];
            double rodY = input[index++];
            double rodZ = input[index++];
            view.worldToView.T.x = input[index++];
            view.worldToView.T.y = input[index++];
            view.worldToView.T.z = input[index++];
            this.rodrigues.setParamVector(rodX, rodY, rodZ);
            ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)this.rodrigues, (DMatrixRMaj)view.worldToView.R);
        }
        for (i = 0; i < structure.cameras.length; ++i) {
            SceneStructureMetric.Camera camera = structure.cameras[i];
            if (camera.known) continue;
            camera.model.setIntrinsic(input, index);
            index += camera.model.getIntrinsicCount();
        }
    }

    @Override
    public void encode(SceneStructureMetric structure, double[] output) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.length; ++i) {
            SceneStructureCommon.Point p = structure.points[i];
            output[index++] = p.coordinate[0];
            output[index++] = p.coordinate[1];
            output[index++] = p.coordinate[2];
            if (!structure.isHomogenous()) continue;
            output[index++] = p.coordinate[3];
        }
        for (int viewIndex = 0; viewIndex < structure.views.length; ++viewIndex) {
            SceneStructureMetric.View view = structure.views[viewIndex];
            if (view.known) continue;
            ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)view.worldToView.R, (Rodrigues_F64)this.rodrigues);
            this.rodrigues.unitAxisRotation.scale(this.rodrigues.theta);
            output[index++] = this.rodrigues.unitAxisRotation.x;
            output[index++] = this.rodrigues.unitAxisRotation.y;
            output[index++] = this.rodrigues.unitAxisRotation.z;
            output[index++] = view.worldToView.T.x;
            output[index++] = view.worldToView.T.y;
            output[index++] = view.worldToView.T.z;
        }
        for (i = 0; i < structure.cameras.length; ++i) {
            SceneStructureMetric.Camera camera = structure.cameras[i];
            if (camera.known) continue;
            camera.model.getIntrinsic(output, index);
            index += camera.model.getIntrinsicCount();
        }
    }
}

