/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.struct.calib.CameraPinholeRadial;
import georegression.struct.point.Point2D_F64;

public class BundlePinholeRadial
implements BundleAdjustmentCamera {
    public boolean zeroSkew = true;
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;
    public double r1;
    public double r2;
    public double t1;
    public double t2;

    public BundlePinholeRadial(boolean zeroSkew) {
        this.zeroSkew = zeroSkew;
    }

    public BundlePinholeRadial() {
    }

    public BundlePinholeRadial(CameraPinholeRadial intrinsic) {
        double[] radial = intrinsic.radial == null ? new double[]{} : intrinsic.radial;
        if (radial.length > 2) {
            throw new RuntimeException("Radial is too long");
        }
        this.zeroSkew = intrinsic.skew == 0.0;
        this.fx = intrinsic.fx;
        this.fy = intrinsic.fy;
        this.cx = intrinsic.cx;
        this.cy = intrinsic.cy;
        this.r2 = 0.0;
        this.r1 = 0.0;
        if (radial.length > 0) {
            this.r1 = radial[0];
        }
        if (radial.length > 1) {
            this.r2 = radial[1];
        }
        this.t1 = intrinsic.t1;
        this.t2 = intrinsic.t2;
        this.skew = intrinsic.skew;
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        this.fx = parameters[offset];
        this.fy = parameters[offset + 1];
        this.cx = parameters[offset + 2];
        this.cy = parameters[offset + 3];
        this.r1 = parameters[offset + 4];
        this.r2 = parameters[offset + 5];
        this.t1 = parameters[offset + 6];
        this.t2 = parameters[offset + 7];
        this.skew = !this.zeroSkew ? parameters[offset + 8] : 0.0;
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        parameters[offset] = this.fx;
        parameters[offset + 1] = this.fy;
        parameters[offset + 2] = this.cx;
        parameters[offset + 3] = this.cy;
        parameters[offset + 4] = this.r1;
        parameters[offset + 5] = this.r2;
        parameters[offset + 6] = this.t1;
        parameters[offset + 7] = this.t2;
        if (!this.zeroSkew) {
            parameters[offset + 8] = this.skew;
        }
    }

    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        double nx = camX / camZ;
        double ny = camY / camZ;
        double rr = nx * nx + ny * ny;
        double sum = (this.r1 + this.r2 * rr) * rr;
        double x = nx * (1.0 + sum);
        double y = ny * (1.0 + sum);
        output.x = this.fx * (x += 2.0 * this.t1 * nx * ny + this.t2 * (rr + 2.0 * nx * nx)) + this.skew * (y += this.t1 * (rr + 2.0 * ny * ny) + 2.0 * this.t2 * nx * ny) + this.cx;
        output.y = this.fy * y + this.cy;
    }

    @Override
    public void jacobian(double camX, double camY, double camZ, double[] inputX, double[] inputY, boolean computeIntrinsic, double[] calibX, double[] calibY) {
        double nx = camX / camZ;
        double ny = camY / camZ;
        double X = camX;
        double Y = camY;
        double Z = camZ;
        double ZZ = Z * Z;
        double rr = nx * nx + ny * ny;
        double sum = (this.r1 + this.r2 * rr) * rr;
        double x = nx * (1.0 + sum);
        double y = ny * (1.0 + sum);
        double A0 = this.r1 + this.r2 * rr;
        double B0 = nx * (this.r2 * rr + A0);
        double B1 = ny * (this.r2 * rr + A0);
        inputX[0] = (this.fx * (2.0 * nx * B0 + (sum + 1.0) + 2.0 * ny * this.t1 + 6.0 * nx * this.t2) + 2.0 * this.skew * (ny * B0 + nx * this.t1 + ny * this.t2)) / Z;
        inputY[0] = 2.0 * this.fy * (ny * B0 + nx * this.t1 + ny * this.t2) / Z;
        inputX[1] = 2.0 * this.fx * (nx * B1 + nx * this.t1 + ny * this.t2) / Z + this.skew * ((2.0 * ny * B1 + sum + 1.0) / Z + 6.0 * ny * this.t1 + 2.0 * nx * this.t2);
        inputY[1] = this.fy * (2.0 * Y * Y * (this.r2 * rr + A0) / Z + (sum + 1.0) * Z + 6.0 * Y * this.t1 + 2.0 * X * this.t2) / ZZ;
        inputX[2] = -(2.0 * this.t2 * (2.0 * nx * nx + rr) + 2.0 * (this.r2 * rr * rr + sum) * nx + (sum + 1.0) * nx + 4.0 * nx * ny * this.t1) * this.fx / Z - (2.0 * this.t1 * (nx * nx + 3.0 * ny * ny) + 2.0 * (this.r2 * rr * rr / Z + sum) * ny + (sum + 1.0) * ny + 4.0 * nx * ny * this.t2) * this.skew / Z;
        inputY[2] = -(2.0 * this.t1 * (rr + 2.0 * ny * ny) + 2.0 * (this.r2 * rr + A0) * rr * Y / Z + (sum + 1.0) * ny + 4.0 * nx * ny * this.t2) * this.fy / Z;
        if (!computeIntrinsic) {
            return;
        }
        calibX[0] = x += 2.0 * this.t1 * nx * ny + this.t2 * (rr + 2.0 * nx * nx);
        calibY[0] = 0.0;
        calibX[1] = 0.0;
        calibY[1] = y += this.t1 * (rr + 2.0 * ny * ny) + 2.0 * this.t2 * nx * ny;
        calibX[2] = 1.0;
        calibY[2] = 0.0;
        calibX[3] = 0.0;
        calibY[3] = 1.0;
        calibX[4] = (nx * this.fx + ny * this.skew) * rr;
        calibY[4] = ny * this.fy * rr;
        calibX[5] = (nx * this.fx + ny * this.skew) * rr * rr;
        calibY[5] = ny * this.fy * rr * rr;
        calibX[6] = this.skew * (rr + 2.0 * ny * ny) + 2.0 * nx * ny * this.fx;
        calibY[6] = this.fy * (rr + 2.0 * ny * ny);
        calibX[7] = this.fx * (rr + 2.0 * nx * nx) + 2.0 * nx * ny * this.skew;
        calibY[7] = 2.0 * nx * ny * this.fy;
        if (!this.zeroSkew) {
            calibX[8] = ny;
            calibY[8] = 0.0;
        }
    }

    @Override
    public int getIntrinsicCount() {
        return this.zeroSkew ? 8 : 9;
    }
}

