/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class HomographyDirectLinearTransform {
    protected DMatrixRMaj A = new DMatrixRMaj(1, 9);
    protected SolveNullSpace<DMatrixRMaj> solverNullspace = new SolveNullSpaceSvd_DDRM();
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    protected NormalizationPoint2D N2 = new NormalizationPoint2D();
    private AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    boolean normalize;

    public HomographyDirectLinearTransform(boolean normalizeInput) {
        this.normalize = normalizeInput;
    }

    public boolean process(List<AssociatedPair> points, DMatrixRMaj foundH) {
        if (points.size() < 4) {
            throw new IllegalArgumentException("Must be at least 4 points.");
        }
        if (this.normalize) {
            LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
            this.createANormalized(points, this.A);
        } else {
            this.createA(points, this.A);
        }
        if (this.computeH(this.A, foundH)) {
            return false;
        }
        if (this.normalize) {
            HomographyDirectLinearTransform.undoNormalizationH(foundH, this.N1, this.N2);
        }
        this.adjust.adjust(foundH, points.get(0));
        return true;
    }

    protected boolean computeH(DMatrixRMaj A, DMatrixRMaj H) {
        if (!this.solverNullspace.process((Matrix)A.copy(), 1, (Matrix)H)) {
            return true;
        }
        H.numRows = 3;
        H.numCols = 3;
        return false;
    }

    public static void undoNormalizationH(DMatrixRMaj M, NormalizationPoint2D N1, NormalizationPoint2D N2) {
        SimpleMatrix a = SimpleMatrix.wrap((Matrix)M);
        SimpleMatrix b = SimpleMatrix.wrap((Matrix)N1.matrix());
        SimpleMatrix c_inv = SimpleMatrix.wrap((Matrix)N2.matrixInv());
        SimpleMatrix result = (SimpleMatrix)((SimpleMatrix)c_inv.mult((SimpleBase)a)).mult((SimpleBase)b);
        M.set((DMatrixD1)result.getDDRM());
    }

    protected void createANormalized(List<AssociatedPair> points, DMatrixRMaj A) {
        A.reshape(points.size() * 2, 9, false);
        A.zero();
        Point2D_F64 f_norm = new Point2D_F64();
        Point2D_F64 s_norm = new Point2D_F64();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            this.N1.apply(f, f_norm);
            this.N2.apply(s, s_norm);
            A.set(i * 2, 3, -f_norm.x);
            A.set(i * 2, 4, -f_norm.y);
            A.set(i * 2, 5, -1.0);
            A.set(i * 2, 6, s_norm.y * f_norm.x);
            A.set(i * 2, 7, s_norm.y * f_norm.y);
            A.set(i * 2, 8, s_norm.y);
            A.set(i * 2 + 1, 0, f_norm.x);
            A.set(i * 2 + 1, 1, f_norm.y);
            A.set(i * 2 + 1, 2, 1.0);
            A.set(i * 2 + 1, 6, -s_norm.x * f_norm.x);
            A.set(i * 2 + 1, 7, -s_norm.x * f_norm.y);
            A.set(i * 2 + 1, 8, -s_norm.x);
        }
    }

    protected void createA(List<AssociatedPair> points, DMatrixRMaj A) {
        A.reshape(points.size() * 2, 9, false);
        A.zero();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            A.set(i * 2, 3, -f.x);
            A.set(i * 2, 4, -f.y);
            A.set(i * 2, 5, -1.0);
            A.set(i * 2, 6, s.y * f.x);
            A.set(i * 2, 7, s.y * f.y);
            A.set(i * 2, 8, s.y);
            A.set(i * 2 + 1, 0, f.x);
            A.set(i * 2 + 1, 1, f.y);
            A.set(i * 2 + 1, 2, 1.0);
            A.set(i * 2 + 1, 6, -s.x * f.x);
            A.set(i * 2 + 1, 7, -s.x * f.y);
            A.set(i * 2 + 1, 8, -s.x);
        }
    }
}

