/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.jacobians;

import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DDRM;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;

public abstract class JacobianSo3Numerical
implements JacobianSo3 {
    private FunctionNtoMxN<DMatrixRMaj> numericalJac;
    private double[] paramInternal;
    private DMatrixRMaj[] jacR;
    private DMatrixRMaj jacobian;
    private int N;
    private FunctionOfPoint function = new FunctionOfPoint();
    private DMatrixRMaj R = new DMatrixRMaj(3, 3);

    public JacobianSo3Numerical() {
        this.init();
    }

    public void init() {
        this.N = this.getParameterLength();
        this.jacR = new DMatrixRMaj[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.jacR[i] = new DMatrixRMaj(3, 3);
        }
        this.jacobian = new DMatrixRMaj(this.N, 9);
        this.paramInternal = new double[this.N];
        this.numericalJac = this.createNumericalAlgorithm(this.function);
    }

    protected FunctionNtoMxN<DMatrixRMaj> createNumericalAlgorithm(FunctionNtoM function) {
        return new NumericalJacobianForward_DDRM(function);
    }

    @Override
    public void setParameters(double[] parameters, int offset) {
        this.computeRotationMatrix(parameters, offset, this.R);
        System.arraycopy(parameters, offset, this.paramInternal, 0, this.N);
        this.numericalJac.process(this.paramInternal, (DMatrix)this.jacobian);
        int idx = 0;
        for (int i = 0; i < 9; ++i) {
            int j = 0;
            while (j < this.N) {
                this.jacR[j].data[i] = this.jacobian.data[idx];
                ++j;
                ++idx;
            }
        }
    }

    public abstract void computeRotationMatrix(double[] var1, int var2, DMatrixRMaj var3);

    @Override
    public DMatrixRMaj getPartial(int param) {
        return this.jacR[param];
    }

    @Override
    public DMatrixRMaj getRotationMatrix() {
        return this.R;
    }

    private class FunctionOfPoint
    implements FunctionNtoM {
        private FunctionOfPoint() {
        }

        public void process(double[] input, double[] output) {
            JacobianSo3Numerical.this.computeRotationMatrix(input, 0, JacobianSo3Numerical.this.R);
            System.arraycopy(((JacobianSo3Numerical)JacobianSo3Numerical.this).R.data, 0, output, 0, 9);
        }

        public int getNumOfInputsN() {
            return JacobianSo3Numerical.this.N;
        }

        public int getNumOfOutputsM() {
            return 9;
        }
    }
}

