/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.Comparator;
import org.ddogleg.struct.GrowQueue_I32;

public class PruneStructureFromSceneProjective {
    SceneStructureProjective structure;
    SceneObservations observations;

    public PruneStructureFromSceneProjective(SceneStructureProjective structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
    }

    public void pruneObservationsByErrorRank(double inlierFraction) {
        int index0;
        Point2D_F64 observation = new Point2D_F64();
        Point2D_F64 predicted = new Point2D_F64();
        Point3D_F64 X3 = new Point3D_F64();
        Point4D_F64 X4 = new Point4D_F64();
        ArrayList<Errors> errors = new ArrayList<Errors>();
        for (int viewIndex = 0; viewIndex < this.observations.views.length; ++viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            SceneStructureProjective.View view = this.structure.views[viewIndex];
            int indexInView = 0;
            while (indexInView < v.point.size) {
                int pointID = v.point.data[indexInView];
                SceneStructureCommon.Point f = this.structure.points[pointID];
                v.get(indexInView, observation);
                if (this.structure.homogenous) {
                    f.get(X4);
                    PerspectiveOps.renderPixel(view.worldToView, X4, predicted);
                } else {
                    f.get(X3);
                    PerspectiveOps.renderPixel(view.worldToView, X3, predicted);
                }
                Errors e = new Errors();
                e.view = viewIndex;
                e.pointIndexInView = indexInView++;
                e.error = predicted.distance2((GeoTuple2D_F64)observation);
                errors.add(e);
            }
        }
        errors.sort(Comparator.comparingDouble(a -> a.error));
        for (int i = index0 = (int)((double)errors.size() * inlierFraction + 0.5); i < errors.size(); ++i) {
            Errors e = (Errors)errors.get(i);
            SceneObservations.View v = this.observations.views[e.view];
            v.set(e.pointIndexInView, Float.NaN, Float.NaN);
        }
        this.removeMarkedObservations();
    }

    public boolean prunePoints(int count) {
        int i;
        int[] oldToNew = new int[this.structure.points.length];
        ArrayList<SceneStructureCommon.Point> remainingP = new ArrayList<SceneStructureCommon.Point>();
        for (int pointIdx = 0; pointIdx < this.structure.points.length; ++pointIdx) {
            SceneStructureCommon.Point sp = this.structure.points[pointIdx];
            if (sp.views.size < count) {
                for (i = 0; i < sp.views.size; ++i) {
                    int viewIdx = sp.views.data[i];
                    SceneObservations.View ov = this.observations.views[viewIdx];
                    int localIdx = ov.point.indexOf(pointIdx);
                    if (localIdx == -1) {
                        throw new RuntimeException("Point not in view's observation!?");
                    }
                    ov.remove(localIdx);
                }
                continue;
            }
            oldToNew[pointIdx] = remainingP.size();
            remainingP.add(sp);
        }
        if (remainingP.size() == this.structure.points.length) {
            return false;
        }
        for (int viewIdx = 0; viewIdx < this.structure.views.length; ++viewIdx) {
            SceneObservations.View so = this.observations.views[viewIdx];
            for (i = 0; i < so.point.size; ++i) {
                so.point.data[i] = oldToNew[so.point.data[i]];
            }
        }
        this.structure.points = new SceneStructureCommon.Point[remainingP.size()];
        for (int i2 = 0; i2 < remainingP.size(); ++i2) {
            this.structure.points[i2] = (SceneStructureCommon.Point)remainingP.get(i2);
        }
        return true;
    }

    public boolean pruneViews(int count) {
        int i;
        GrowQueue_I32 viewsIn;
        int pointIdx;
        ArrayList<SceneStructureProjective.View> remainingS = new ArrayList<SceneStructureProjective.View>();
        ArrayList<SceneObservations.View> remainingO = new ArrayList<SceneObservations.View>();
        int[] counts = new int[this.structure.views.length];
        for (pointIdx = 0; pointIdx < this.structure.points.length; ++pointIdx) {
            viewsIn = this.structure.points[pointIdx].views;
            for (i = 0; i < viewsIn.size; ++i) {
                int n = viewsIn.get(i);
                counts[n] = counts[n] + 1;
            }
        }
        for (int viewIdx = 0; viewIdx < this.structure.views.length; ++viewIdx) {
            if (counts[viewIdx] > count) {
                remainingS.add(this.structure.views[viewIdx]);
                remainingO.add(this.observations.views[viewIdx]);
                continue;
            }
            this.structure.views[viewIdx].width = -2;
        }
        for (pointIdx = 0; pointIdx < this.structure.points.length; ++pointIdx) {
            viewsIn = this.structure.points[pointIdx].views;
            for (i = viewsIn.size - 1; i >= 0; --i) {
                SceneStructureProjective.View v = this.structure.views[viewsIn.get(i)];
                if (v.width != -2) continue;
                viewsIn.remove(i);
            }
        }
        if (this.structure.views.length == remainingS.size()) {
            return false;
        }
        this.structure.views = new SceneStructureProjective.View[remainingS.size()];
        this.observations.views = new SceneObservations.View[remainingO.size()];
        for (int i2 = 0; i2 < this.structure.views.length; ++i2) {
            this.structure.views[i2] = (SceneStructureProjective.View)remainingS.get(i2);
            this.observations.views[i2] = (SceneObservations.View)remainingO.get(i2);
        }
        return true;
    }

    private void removeMarkedObservations() {
        Point2D_F64 observation = new Point2D_F64();
        for (int viewIndex = 0; viewIndex < this.observations.views.length; ++viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            for (int indexInView = v.point.size - 1; indexInView >= 0; --indexInView) {
                int pointID = v.getPointId(indexInView);
                SceneStructureCommon.Point f = this.structure.points[pointID];
                v.get(indexInView, observation);
                if (!Double.isNaN(v.observations.get(indexInView * 2))) continue;
                f.removeView(viewIndex);
                v.remove(indexInView);
            }
        }
    }

    private static class Errors {
        int view;
        int pointIndexInView;
        double error;

        private Errors() {
        }
    }
}

