/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.spherical.EquirectangularTools_F64;
import boofcv.struct.distort.PixelTransform;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public abstract class EquirectangularDistortBase_F64
implements PixelTransform<Point2D_F64> {
    EquirectangularTools_F64 tools = new EquirectangularTools_F64();
    int outWidth;
    DMatrixRMaj R = CommonOps_DDRM.identity((int)3, (int)3);
    Vector3D_F64 n = new Vector3D_F64();
    Point3D_F64[] vectors = new Point3D_F64[0];

    public void setEquirectangularShape(int width, int height) {
        this.tools.configure(width, height);
    }

    public void setDirection(double yaw, double pitch, double roll) {
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.YZX, (double)pitch, (double)yaw, (double)roll, (DMatrixRMaj)this.R);
    }

    public void setDirection(DMatrixRMaj R) {
        this.R.set((DMatrixD1)R);
    }

    protected void declareVectors(int width, int height) {
        this.outWidth = width;
        if (this.vectors.length < width * height) {
            Point3D_F64[] tmp = new Point3D_F64[width * height];
            System.arraycopy(this.vectors, 0, tmp, 0, this.vectors.length);
            for (int i = this.vectors.length; i < tmp.length; ++i) {
                tmp[i] = new Point3D_F64();
            }
            this.vectors = tmp;
        }
    }

    public void compute(int x, int y, Point2D_F64 out) {
        Point3D_F64 v = this.vectors[y * this.outWidth + x];
        GeometryMath_F64.mult((DMatrixRMaj)this.R, (GeoTuple3D_F64)v, (GeoTuple3D_F64)this.n);
        this.tools.normToEquiFV(this.n.x, this.n.y, this.n.z, out);
    }

    public EquirectangularTools_F64 getTools() {
        return this.tools;
    }

    public DMatrixRMaj getRotation() {
        return this.R;
    }
}

