/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;

public class LowLevelMultiViewOps {
    public static void computeNormalization(List<Point2D_F64> points, NormalizationPoint2D normalize) {
        double meanX = 0.0;
        double meanY = 0.0;
        for (Point2D_F64 p : points) {
            meanX += p.x;
            meanY += p.y;
        }
        meanX /= (double)points.size();
        meanY /= (double)points.size();
        double stdX = 0.0;
        double stdY = 0.0;
        for (Point2D_F64 p : points) {
            double dx = p.x - meanX;
            double dy = p.y - meanY;
            stdX += dx * dx;
            stdY += dy * dy;
        }
        normalize.meanX = meanX;
        normalize.meanY = meanY;
        normalize.stdX = Math.sqrt(stdX / (double)points.size());
        normalize.stdY = Math.sqrt(stdY / (double)points.size());
    }

    public static void computeNormalizationLL(List<List<Point2D_F64>> points, NormalizationPoint2D normalize) {
        double meanX = 0.0;
        double meanY = 0.0;
        int count = 0;
        for (int i = 0; i < points.size(); ++i) {
            List<Point2D_F64> l = points.get(i);
            for (int j = 0; j < l.size(); ++j) {
                Point2D_F64 p = l.get(j);
                meanX += p.x;
                meanY += p.y;
            }
            count += l.size();
        }
        meanX /= (double)count;
        meanY /= (double)count;
        double stdX = 0.0;
        double stdY = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            List<Point2D_F64> l = points.get(i);
            for (int j = 0; j < l.size(); ++j) {
                Point2D_F64 p = l.get(j);
                double dx = p.x - meanX;
                double dy = p.y - meanY;
                stdX += dx * dx;
                stdY += dy * dy;
            }
        }
        normalize.meanX = meanX;
        normalize.meanY = meanY;
        normalize.stdX = Math.sqrt(stdX / (double)count);
        normalize.stdY = Math.sqrt(stdY / (double)count);
    }

    public static void computeNormalization(List<AssociatedPair> points, NormalizationPoint2D N1, NormalizationPoint2D N2) {
        double meanX1 = 0.0;
        double meanY1 = 0.0;
        double meanX2 = 0.0;
        double meanY2 = 0.0;
        for (AssociatedPair p : points) {
            meanX1 += p.p1.x;
            meanY1 += p.p1.y;
            meanX2 += p.p2.x;
            meanY2 += p.p2.y;
        }
        meanX1 /= (double)points.size();
        meanY1 /= (double)points.size();
        meanX2 /= (double)points.size();
        meanY2 /= (double)points.size();
        double stdX1 = 0.0;
        double stdY1 = 0.0;
        double stdX2 = 0.0;
        double stdY2 = 0.0;
        for (AssociatedPair p : points) {
            double dx = p.p1.x - meanX1;
            double dy = p.p1.y - meanY1;
            stdX1 += dx * dx;
            stdY1 += dy * dy;
            dx = p.p2.x - meanX2;
            dy = p.p2.y - meanY2;
            stdX2 += dx * dx;
            stdY2 += dy * dy;
        }
        N1.meanX = meanX1;
        N1.meanY = meanY1;
        N2.meanX = meanX2;
        N2.meanY = meanY2;
        N1.stdX = Math.sqrt(stdX1 / (double)points.size());
        N1.stdY = Math.sqrt(stdY1 / (double)points.size());
        N2.stdX = Math.sqrt(stdX2 / (double)points.size());
        N2.stdY = Math.sqrt(stdY2 / (double)points.size());
    }

    public static void computeNormalization(List<AssociatedTriple> points, NormalizationPoint2D N1, NormalizationPoint2D N2, NormalizationPoint2D N3) {
        double meanX1 = 0.0;
        double meanY1 = 0.0;
        double meanX2 = 0.0;
        double meanY2 = 0.0;
        double meanX3 = 0.0;
        double meanY3 = 0.0;
        for (AssociatedTriple p : points) {
            meanX1 += p.p1.x;
            meanY1 += p.p1.y;
            meanX2 += p.p2.x;
            meanY2 += p.p2.y;
            meanX3 += p.p3.x;
            meanY3 += p.p3.y;
        }
        meanX1 /= (double)points.size();
        meanY1 /= (double)points.size();
        meanX2 /= (double)points.size();
        meanY2 /= (double)points.size();
        meanX3 /= (double)points.size();
        meanY3 /= (double)points.size();
        double stdX1 = 0.0;
        double stdY1 = 0.0;
        double stdX2 = 0.0;
        double stdY2 = 0.0;
        double stdX3 = 0.0;
        double stdY3 = 0.0;
        for (AssociatedTriple p : points) {
            double dx = p.p1.x - meanX1;
            double dy = p.p1.y - meanY1;
            stdX1 += dx * dx;
            stdY1 += dy * dy;
            dx = p.p2.x - meanX2;
            dy = p.p2.y - meanY2;
            stdX2 += dx * dx;
            stdY2 += dy * dy;
            dx = p.p3.x - meanX3;
            dy = p.p3.y - meanY3;
            stdX3 += dx * dx;
            stdY3 += dy * dy;
        }
        N1.meanX = meanX1;
        N1.meanY = meanY1;
        N2.meanX = meanX2;
        N2.meanY = meanY2;
        N3.meanX = meanX3;
        N3.meanY = meanY3;
        N1.stdX = Math.sqrt(stdX1 / (double)points.size());
        N1.stdY = Math.sqrt(stdY1 / (double)points.size());
        N2.stdX = Math.sqrt(stdX2 / (double)points.size());
        N2.stdY = Math.sqrt(stdY2 / (double)points.size());
        N3.stdX = Math.sqrt(stdX3 / (double)points.size());
        N3.stdY = Math.sqrt(stdY3 / (double)points.size());
    }

    public static void applyNormalization(List<AssociatedPair> points, NormalizationPoint2D N1, NormalizationPoint2D N2, DMatrix1Row X1, DMatrixRMaj X2) {
        int size = points.size();
        X1.reshape(size, 2);
        X2.reshape(size, 2);
        int i = 0;
        int index = 0;
        while (i < size) {
            AssociatedPair pair = points.get(i);
            X1.data[index] = (pair.p1.x - N1.meanX) / N1.stdX;
            X1.data[index + 1] = (pair.p1.y - N1.meanY) / N1.stdY;
            X2.data[index] = (pair.p2.x - N2.meanX) / N2.stdX;
            X2.data[index + 1] = (pair.p2.y - N2.meanY) / N2.stdY;
            ++i;
            index += 2;
        }
    }
}

