/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.ModelObservationResidual;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class EssentialResidualSampson
implements ModelObservationResidual<DMatrixRMaj, AssociatedPair> {
    DMatrixRMaj E;
    DMatrixRMaj K2E = new DMatrixRMaj(3, 3);
    DMatrixRMaj EK1 = new DMatrixRMaj(3, 3);
    Point3D_F64 temp = new Point3D_F64();
    DMatrixRMaj K1_inv = new DMatrixRMaj(3, 3);
    DMatrixRMaj K2_inv = new DMatrixRMaj(3, 3);

    public void setCalibration1(CameraPinhole pinhole) {
        DMatrixRMaj K = new DMatrixRMaj(3, 3);
        PerspectiveOps.pinholeToMatrix(pinhole, K);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)this.K1_inv);
    }

    public void setCalibration2(CameraPinhole pinhole) {
        DMatrixRMaj K = new DMatrixRMaj(3, 3);
        PerspectiveOps.pinholeToMatrix(pinhole, K);
        CommonOps_DDRM.invert((DMatrixRMaj)K, (DMatrixRMaj)this.K2_inv);
    }

    @Override
    public void setModel(DMatrixRMaj E) {
        this.E = E;
        CommonOps_DDRM.multTransA((DMatrix1Row)this.K2_inv, (DMatrix1Row)E, (DMatrix1Row)this.K2E);
        CommonOps_DDRM.mult((DMatrix1Row)E, (DMatrix1Row)this.K1_inv, (DMatrix1Row)this.EK1);
    }

    @Override
    public double computeResidual(AssociatedPair observation) {
        double bottom = 0.0;
        GeometryMath_F64.mult((DMatrixRMaj)this.K2E, (GeoTuple2D_F64)observation.p1, (GeoTuple3D_F64)this.temp);
        bottom += this.temp.x * this.temp.x + this.temp.y * this.temp.y;
        GeometryMath_F64.multTran((DMatrixRMaj)this.EK1, (GeoTuple2D_F64)observation.p2, (GeoTuple3D_F64)this.temp);
        if ((bottom += this.temp.x * this.temp.x + this.temp.y * this.temp.y) == 0.0) {
            return Double.MAX_VALUE;
        }
        GeometryMath_F64.multTran((DMatrixRMaj)this.E, (GeoTuple2D_F64)observation.p2, (GeoTuple3D_F64)this.temp);
        return (this.temp.x * observation.p1.x + this.temp.y * observation.p1.y + this.temp.z) / bottom;
    }
}

