/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.pose.P3PGrunert;
import boofcv.alg.geo.pose.P3PLineDistance;
import boofcv.alg.geo.pose.PointDistance3;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.Complex_F64;

public class P3PFinsterwalder
implements P3PLineDistance {
    private FastQueue<PointDistance3> solutions = new FastQueue(4, PointDistance3.class, true);
    private double a2;
    private double b2;
    private double c2;
    private double cos12;
    private double cos13;
    private double cos23;
    double p;
    double q;
    private PolynomialRoots rootFinder;
    private Polynomial poly = new Polynomial(4);

    public P3PFinsterwalder(PolynomialRoots rootFinder) {
        this.rootFinder = rootFinder;
    }

    @Override
    public boolean process(Point2D_F64 obs1, Point2D_F64 obs2, Point2D_F64 obs3, double length23, double length13, double length12) {
        this.solutions.reset();
        this.cos12 = P3PGrunert.computeCosine(obs1, obs2);
        this.cos13 = P3PGrunert.computeCosine(obs1, obs3);
        this.cos23 = P3PGrunert.computeCosine(obs2, obs3);
        double a = length23;
        double b = length13;
        double c = length12;
        double a2_d_b2 = a / b * (a / b);
        double c2_d_b2 = c / b * (c / b);
        this.a2 = a * a;
        this.b2 = b * b;
        this.c2 = c * c;
        this.poly.c[0] = this.a2 * (this.a2 * (1.0 - P3PGrunert.pow2(this.cos13)) + this.b2 * (P3PGrunert.pow2(this.cos23) - 1.0));
        this.poly.c[1] = 2.0 * this.a2 * this.b2 * (this.cos12 * this.cos13 * this.cos23 - 1.0) + this.a2 * (this.a2 + 2.0 * this.c2) * (1.0 - P3PGrunert.pow2(this.cos13)) + this.b2 * (this.b2 - this.c2) * (1.0 - P3PGrunert.pow2(this.cos23));
        this.poly.c[2] = 2.0 * this.c2 * this.b2 * (this.cos12 * this.cos13 * this.cos23 - 1.0) + this.c2 * (this.c2 + 2.0 * this.a2) * (1.0 - P3PGrunert.pow2(this.cos13)) + this.b2 * (this.b2 - this.a2) * (1.0 - P3PGrunert.pow2(this.cos12));
        this.poly.c[3] = this.c2 * (this.b2 * (P3PGrunert.pow2(this.cos12) - 1.0) + this.c2 * (1.0 - P3PGrunert.pow2(this.cos13)));
        if (this.poly.computeDegree() < 0) {
            return false;
        }
        if (!this.rootFinder.process(this.poly)) {
            return false;
        }
        Complex_F64 root = null;
        for (Complex_F64 r : this.rootFinder.getRoots()) {
            if (!r.isReal()) continue;
            root = r;
            break;
        }
        if (root == null) {
            return false;
        }
        double lambda = root.real;
        double A = 1.0 + lambda;
        double B = -this.cos23;
        double C = 1.0 - a2_d_b2 - lambda * c2_d_b2;
        double D = -lambda * this.cos12;
        double E = (a2_d_b2 + lambda * c2_d_b2) * this.cos13;
        double F = -a2_d_b2 + lambda * (1.0 - c2_d_b2);
        this.p = Math.sqrt(B * B - A * C);
        this.q = Math.signum(B * E - C * D) * Math.sqrt(E * E - C * F);
        this.computeU((-B + this.p) / C, (-E + this.q) / C);
        this.computeU((-B - this.p) / C, (-E - this.q) / C);
        return true;
    }

    private void computeU(double m, double n) {
        double B = this.c2 * (this.cos13 - n) * m - this.b2 * this.cos12;
        double A = this.b2 - m * m * this.c2;
        double C = -this.c2 * n * n + 2.0 * this.c2 * n * this.cos13 + this.b2 - this.c2;
        double insideSqrt = B * B - A * C;
        if (insideSqrt < 0.0) {
            return;
        }
        double u_large = -Math.signum(B) * (Math.abs(B) + Math.sqrt(insideSqrt)) / A;
        double u_small = C / (A * u_large);
        this.computeSolution(u_large, u_large * m + n);
        this.computeSolution(u_small, u_small * m + n);
    }

    private void computeSolution(double u, double v) {
        double bottom = u * u + v * v - 2.0 * u * v * this.cos23;
        if (bottom == 0.0) {
            return;
        }
        double inner = this.a2 / bottom;
        if (inner >= 0.0) {
            PointDistance3 s = (PointDistance3)this.solutions.grow();
            s.dist1 = Math.sqrt(inner);
            s.dist2 = s.dist1 * u;
            s.dist3 = s.dist1 * v;
        }
    }

    @Override
    public FastQueue<PointDistance3> getSolutions() {
        return this.solutions;
    }
}

