/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class TrifocalExtractGeometries {
    private TrifocalTensor tensor;
    private SingularValueDecomposition_F64<DMatrixRMaj> svd;
    private DMatrixRMaj u1 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj u2 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj u3 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj v1 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj v2 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj v3 = new DMatrixRMaj(3, 1);
    private DMatrixRMaj U = new DMatrixRMaj(3, 3);
    private DMatrixRMaj V = new DMatrixRMaj(3, 3);
    private DMatrixRMaj tempE = new DMatrixRMaj(3, 1);
    Point3D_F64 column = new Point3D_F64();
    Point3D_F64 temp0 = new Point3D_F64();
    DMatrixRMaj temp1 = new DMatrixRMaj(3, 3);
    Point3D_F64 e2 = new Point3D_F64();
    Point3D_F64 e3 = new Point3D_F64();

    public TrifocalExtractGeometries() {
        this.svd = DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)true);
        this.svd = new SafeSvd_DDRM(this.svd);
    }

    public void setTensor(TrifocalTensor tensor) {
        this.tensor = tensor;
        if (!this.svd.decompose((Matrix)tensor.T1)) {
            throw new RuntimeException("SVD failed?!");
        }
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.v1);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.u1);
        if (!this.svd.decompose((Matrix)tensor.T2)) {
            throw new RuntimeException("SVD failed?!");
        }
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.v2);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.u2);
        if (!this.svd.decompose((Matrix)tensor.T3)) {
            throw new RuntimeException("SVD failed?!");
        }
        SingularOps_DDRM.nullVector(this.svd, (boolean)true, (DMatrixRMaj)this.v3);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.u3);
        for (int i = 0; i < 3; ++i) {
            this.U.set(i, 0, this.u1.get(i));
            this.U.set(i, 1, this.u2.get(i));
            this.U.set(i, 2, this.u3.get(i));
            this.V.set(i, 0, this.v1.get(i));
            this.V.set(i, 1, this.v2.get(i));
            this.V.set(i, 2, this.v3.get(i));
        }
        this.svd.decompose((Matrix)this.U);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.tempE);
        this.e2.set(this.tempE.get(0), this.tempE.get(1), this.tempE.get(2));
        this.svd.decompose((Matrix)this.V);
        SingularOps_DDRM.nullVector(this.svd, (boolean)false, (DMatrixRMaj)this.tempE);
        this.e3.set(this.tempE.get(0), this.tempE.get(1), this.tempE.get(2));
    }

    public void extractEpipoles(Point3D_F64 e2, Point3D_F64 e3) {
        e2.set(this.e2);
        e3.set(this.e3);
    }

    public void extractCamera(DMatrixRMaj P2, DMatrixRMaj P3) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.temp1.set(i, j, this.e3.getIdx(i) * this.e3.getIdx(j));
            }
            this.temp1.set(i, i, this.temp1.get(i, i) - 1.0);
        }
        for (i = 0; i < 3; ++i) {
            DMatrixRMaj T = this.tensor.getT(i);
            GeometryMath_F64.mult((DMatrixRMaj)T, (GeoTuple3D_F64)this.e3, (GeoTuple3D_F64)this.column);
            P2.set(0, i, this.column.x);
            P2.set(1, i, this.column.y);
            P2.set(2, i, this.column.z);
            P2.set(i, 3, this.e2.getIdx(i));
            GeometryMath_F64.multTran((DMatrixRMaj)T, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.temp0);
            GeometryMath_F64.mult((DMatrixRMaj)this.temp1, (GeoTuple3D_F64)this.temp0, (GeoTuple3D_F64)this.column);
            P3.set(0, i, this.column.x);
            P3.set(1, i, this.column.y);
            P3.set(2, i, this.column.z);
            P3.set(i, 3, this.e3.getIdx(i));
        }
    }

    public void extractFundmental(DMatrixRMaj F21, DMatrixRMaj F31) {
        for (int i = 0; i < 3; ++i) {
            DMatrixRMaj T = this.tensor.getT(i);
            GeometryMath_F64.mult((DMatrixRMaj)T, (GeoTuple3D_F64)this.e3, (GeoTuple3D_F64)this.temp0);
            GeometryMath_F64.cross((GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.temp0, (GeoTuple3D_F64)this.column);
            F21.set(0, i, this.column.x);
            F21.set(1, i, this.column.y);
            F21.set(2, i, this.column.z);
            GeometryMath_F64.multTran((DMatrixRMaj)T, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.temp0);
            GeometryMath_F64.cross((GeoTuple3D_F64)this.e3, (GeoTuple3D_F64)this.temp0, (GeoTuple3D_F64)this.column);
            F31.set(0, i, this.column.x);
            F31.set(1, i, this.column.y);
            F31.set(2, i, this.column.z);
        }
    }
}

