/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.ConfigTrackerDda;
import boofcv.abst.feature.tracker.DdaManagerDetectDescribePoint;
import boofcv.abst.feature.tracker.DdaManagerGeneralPoint;
import boofcv.abst.feature.tracker.DetectDescribeAssociateTwoPass;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.feature.tracker.PointTrackerTwoPassKltPyramid;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.PyramidDiscrete;

public class FactoryPointTrackerTwoPass {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTrackerTwoPass<I> klt(PkltConfig config, ConfigGeneralDetector configExtract, Class<I> imageType, Class<D> derivType) {
        GeneralFeatureDetector detector = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle(derivType);
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        PyramidDiscrete pyramid = FactoryPyramid.discreteGaussian((int[])config.pyramidScaling, (double)-1.0, (int)2, (boolean)true, (ImageType)ImageType.single(imageType));
        return new PointTrackerTwoPassKltPyramid(config.config, config.templateRadius, pyramid, detector, gradient, interpInput, interpDeriv);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> PointTrackerTwoPass<I> dda(GeneralFeatureDetector<I, D> detector, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate1, AssociateDescription2D<Desc> associate2, double scale, ConfigTrackerDda config, Class<I> imageType) {
        EasyGeneralFeatureDetector easy = new EasyGeneralFeatureDetector(detector, imageType, null);
        DdaManagerGeneralPoint manager = new DdaManagerGeneralPoint(easy, describe, scale);
        if (associate2 == null) {
            associate2 = associate1;
        }
        return new DetectDescribeAssociateTwoPass(manager, associate1, associate2, config);
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> PointTrackerTwoPass<I> dda(DetectDescribePoint<I, Desc> detectDescribe, AssociateDescription2D<Desc> associate1, AssociateDescription2D<Desc> associate2, ConfigTrackerDda config) {
        DdaManagerDetectDescribePoint<I, Desc> manager = new DdaManagerDetectDescribePoint<I, Desc>(detectDescribe);
        if (associate2 == null) {
            associate2 = associate1;
        }
        return new DetectDescribeAssociateTwoPass<I, Desc>(manager, associate1, associate2, config);
    }
}

