/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;

public class SceneStructureProjective
extends SceneStructureCommon {
    public final FastQueue<View> views = new FastQueue(View.class, true);

    public SceneStructureProjective(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalViews, int totalPoints) {
        int i;
        this.views.resize(totalViews);
        this.points.resize(totalPoints);
        for (i = 0; i < this.views.size; ++i) {
            ((View[])this.views.data)[i].reset();
        }
        for (i = 0; i < this.points.size; ++i) {
            ((SceneStructureCommon.Point[])this.points.data)[i].reset();
        }
    }

    public void setView(int which, boolean fixed, DMatrixRMaj worldToView, int width, int height) {
        ((View[])this.views.data)[which].known = fixed;
        ((View[])this.views.data)[which].worldToView.set((DMatrixD1)worldToView);
        ((View[])this.views.data)[which].width = width;
        ((View[])this.views.data)[which].height = height;
    }

    public int getUnknownViewCount() {
        int total = 0;
        for (int i = 0; i < this.views.size; ++i) {
            if (((View[])this.views.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownViewCount() * 12 + this.points.size * this.pointSize;
    }

    public FastQueue<View> getViews() {
        return this.views;
    }

    public static class View {
        public boolean known = true;
        public int width;
        public int height;
        public DMatrixRMaj worldToView = new DMatrixRMaj(3, 4);

        public void reset() {
            this.known = false;
            this.height = 0;
            this.width = 0;
            this.worldToView.zero();
        }
    }
}

