/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.fitting;

import boofcv.alg.geo.ModelObservationResidualN;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceFromModelResidualN<Model, Point>
implements DistanceFromModel<Model, Point> {
    ModelObservationResidualN<Model, Point> function;
    double[] residuals;

    public DistanceFromModelResidualN(ModelObservationResidualN<Model, Point> function) {
        this.function = function;
        this.residuals = new double[function.getN()];
    }

    public void setModel(Model F) {
        this.function.setModel(F);
    }

    public double computeDistance(Point pt) {
        this.function.computeResiduals(pt, this.residuals, 0);
        double dist = 0.0;
        for (int i = 0; i < this.residuals.length; ++i) {
            double r = this.residuals[i];
            dist += r * r;
        }
        return dist;
    }

    public void computeDistance(List<Point> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            Point p = associatedPairs.get(i);
            this.function.computeResiduals(p, this.residuals, 0);
            double dist = 0.0;
            for (int j = 0; j < this.residuals.length; ++j) {
                double r = this.residuals[j];
                dist += r * r;
            }
            distance[i] = dist;
        }
    }

    public Class<Point> getPointType() {
        return null;
    }

    public Class<Model> getModelType() {
        return null;
    }
}

