/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.spherical.EquirectangularDistortBase_F32;
import georegression.misc.GrlConstants;

public class CylinderToEquirectangular_F32
extends EquirectangularDistortBase_F32 {
    public void configure(int width, int height, float vfov) {
        this.declareVectors(width, height);
        float r = (float)Math.tan(vfov / 2.0f);
        for (int pixelY = 0; pixelY < height; ++pixelY) {
            float z = 2.0f * r * (float)pixelY / (float)(height - 1) - r;
            for (int pixelX = 0; pixelX < width; ++pixelX) {
                float theta = GrlConstants.F_PI2 * (float)pixelX / (float)width - GrlConstants.F_PI;
                float x = (float)Math.cos(theta);
                float y = (float)Math.sin(theta);
                this.vectors[pixelY * width + pixelX].set(x, y, z);
            }
        }
    }

    public CylinderToEquirectangular_F32 copyConcurrent() {
        CylinderToEquirectangular_F32 out = new CylinderToEquirectangular_F32();
        out.setTo(this);
        return out;
    }
}

