/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import javax.annotation.Nullable;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ReshapeMatrix;

public abstract class BundleAdjustmentProjectiveSchurJacobian<M extends DMatrix>
implements BundleAdjustmentSchur.Jacobian<SceneStructureProjective, M> {
    private SceneStructureProjective structure;
    private SceneObservations observations;
    private DMatrixRMaj worldToView = new DMatrixRMaj(3, 4);
    private int numViewsUnknown;
    private int numParameters;
    private int lengthPoint;
    private Point4D_F64 worldPt = new Point4D_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private int indexFirstView;
    private int[] viewParameterIndexes;
    private int jacRowX;
    private int jacRowY;
    private double[] pointGradX = new double[4];
    private double[] pointGradY = new double[4];
    private double[] camGradX = new double[12];
    private double[] camGradY = new double[12];

    @Override
    public void configure(SceneStructureProjective structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        if (!structure.isHomogenous()) {
            this.worldPt.w = 1.0;
            this.lengthPoint = 3;
        } else {
            this.lengthPoint = 4;
        }
        this.numViewsUnknown = structure.getUnknownViewCount();
        this.indexFirstView = structure.points.size * this.lengthPoint;
        this.numParameters = this.indexFirstView + this.numViewsUnknown * 12;
        this.viewParameterIndexes = new int[structure.views.size];
        int index = 0;
        for (int i = 0; i < structure.views.size; ++i) {
            this.viewParameterIndexes[i] = index;
            if (((SceneStructureProjective.View[])structure.views.data)[i].known) continue;
            index += 12;
        }
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.observations.getObservationCount() * 2;
    }

    public void processInternal(double[] input, DMatrix leftPoint, DMatrix rightView) {
        int numRows = this.getNumOfOutputsM();
        int numPointParam = this.structure.points.size * this.lengthPoint;
        int numViewParam = this.numParameters - numPointParam;
        ((ReshapeMatrix)leftPoint).reshape(numRows, numPointParam);
        ((ReshapeMatrix)rightView).reshape(numRows, numViewParam);
        leftPoint.zero();
        rightView.zero();
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            int i;
            SceneStructureProjective.View view = ((SceneStructureProjective.View[])this.structure.views.data)[viewIndex];
            if (!view.known) {
                int paramIndex = this.viewParameterIndexes[viewIndex] + this.indexFirstView;
                for (i = 0; i < 12; ++i) {
                    this.worldToView.data[i] = input[paramIndex++];
                }
            } else {
                this.worldToView.set((DMatrixD1)view.worldToView);
            }
            SceneObservations.View obsView = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            for (i = 0; i < obsView.size(); ++i) {
                int featureIndex = obsView.point.get(i);
                int columnOfPointInJac = featureIndex * this.lengthPoint;
                this.worldPt.x = input[columnOfPointInJac];
                this.worldPt.y = input[columnOfPointInJac + 1];
                this.worldPt.z = input[columnOfPointInJac + 2];
                if (this.structure.isHomogenous()) {
                    this.worldPt.w = input[columnOfPointInJac + 3];
                }
                PerspectiveOps.renderPixel(this.worldToView, this.worldPt, this.cameraPt);
                if (view.known) {
                    if (this.structure.isHomogenous()) {
                        BundleAdjustmentProjectiveSchurJacobian.partialCameraModelH(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldPt.w, this.worldToView, this.pointGradX, this.pointGradY, null, null);
                    } else {
                        BundleAdjustmentProjectiveSchurJacobian.partialCameraModel(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldToView, this.pointGradX, this.pointGradY, null, null);
                    }
                } else if (this.structure.isHomogenous()) {
                    BundleAdjustmentProjectiveSchurJacobian.partialCameraModelH(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldPt.w, this.worldToView, this.pointGradX, this.pointGradY, this.camGradX, this.camGradY);
                } else {
                    BundleAdjustmentProjectiveSchurJacobian.partialCameraModel(this.worldPt.x, this.worldPt.y, this.worldPt.z, this.worldToView, this.pointGradX, this.pointGradY, this.camGradX, this.camGradY);
                }
                this.jacRowX = observationIndex * 2;
                this.jacRowY = this.jacRowX + 1;
                this.addToJacobian(leftPoint, columnOfPointInJac, this.lengthPoint, this.pointGradX, this.pointGradY);
                if (!view.known) {
                    int col = this.viewParameterIndexes[viewIndex];
                    this.addToJacobian(rightView, col, 12, this.camGradX, this.camGradY);
                }
                ++observationIndex;
            }
        }
    }

    static void partialCameraModel(double X, double Y, double Z, DMatrixRMaj P, double[] pixelGradX, double[] pixelGradY, @Nullable double[] camGradX, @Nullable double[] camGradY) {
        double P11 = P.data[0];
        double P12 = P.data[1];
        double P13 = P.data[2];
        double P14 = P.data[3];
        double P21 = P.data[4];
        double P22 = P.data[5];
        double P23 = P.data[6];
        double P24 = P.data[7];
        double P31 = P.data[8];
        double P32 = P.data[9];
        double P33 = P.data[10];
        double P34 = P.data[11];
        double xx = P11 * X + P12 * Y + P13 * Z + P14;
        double yy = P21 * X + P22 * Y + P23 * Z + P24;
        double zz = P31 * X + P32 * Y + P33 * Z + P34;
        double zz2 = zz * zz;
        pixelGradX[0] = P11 / zz - P31 * xx / zz2;
        pixelGradX[1] = P12 / zz - P32 * xx / zz2;
        pixelGradX[2] = P13 / zz - P33 * xx / zz2;
        pixelGradY[0] = P21 / zz - P31 * yy / zz2;
        pixelGradY[1] = P22 / zz - P32 * yy / zz2;
        pixelGradY[2] = P23 / zz - P33 * yy / zz2;
        if (camGradX == null || camGradY == null) {
            return;
        }
        camGradX[0] = X / zz;
        camGradX[1] = Y / zz;
        camGradX[2] = Z / zz;
        camGradX[3] = 1.0 / zz;
        camGradX[4] = 0.0;
        camGradX[5] = 0.0;
        camGradX[6] = 0.0;
        camGradX[7] = 0.0;
        camGradX[8] = -X * xx / zz2;
        camGradX[9] = -Y * xx / zz2;
        camGradX[10] = -Z * xx / zz2;
        camGradX[11] = -xx / zz2;
        camGradY[0] = 0.0;
        camGradY[1] = 0.0;
        camGradY[2] = 0.0;
        camGradY[3] = 0.0;
        camGradY[4] = X / zz;
        camGradY[5] = Y / zz;
        camGradY[6] = Z / zz;
        camGradY[7] = 1.0 / zz;
        camGradY[8] = -X * yy / zz2;
        camGradY[9] = -Y * yy / zz2;
        camGradY[10] = -Z * yy / zz2;
        camGradY[11] = -yy / zz2;
    }

    static void partialCameraModelH(double X, double Y, double Z, double W, DMatrixRMaj P, double[] pixelGradX, double[] pixelGradY, @Nullable double[] camGradX, @Nullable double[] camGradY) {
        double P11 = P.data[0];
        double P12 = P.data[1];
        double P13 = P.data[2];
        double P14 = P.data[3];
        double P21 = P.data[4];
        double P22 = P.data[5];
        double P23 = P.data[6];
        double P24 = P.data[7];
        double P31 = P.data[8];
        double P32 = P.data[9];
        double P33 = P.data[10];
        double P34 = P.data[11];
        double xx = P11 * X + P12 * Y + P13 * Z + P14 * W;
        double yy = P21 * X + P22 * Y + P23 * Z + P24 * W;
        double zz = P31 * X + P32 * Y + P33 * Z + P34 * W;
        double zz2 = zz * zz;
        pixelGradX[0] = P11 / zz - P31 * xx / zz2;
        pixelGradX[1] = P12 / zz - P32 * xx / zz2;
        pixelGradX[2] = P13 / zz - P33 * xx / zz2;
        pixelGradX[3] = P14 / zz - P34 * xx / zz2;
        pixelGradY[0] = P21 / zz - P31 * yy / zz2;
        pixelGradY[1] = P22 / zz - P32 * yy / zz2;
        pixelGradY[2] = P23 / zz - P33 * yy / zz2;
        pixelGradY[3] = P24 / zz - P34 * yy / zz2;
        if (camGradX == null || camGradY == null) {
            return;
        }
        camGradX[0] = X / zz;
        camGradX[1] = Y / zz;
        camGradX[2] = Z / zz;
        camGradX[3] = W / zz;
        camGradX[4] = 0.0;
        camGradX[5] = 0.0;
        camGradX[6] = 0.0;
        camGradX[7] = 0.0;
        camGradX[8] = -X * xx / zz2;
        camGradX[9] = -Y * xx / zz2;
        camGradX[10] = -Z * xx / zz2;
        camGradX[11] = -W * xx / zz2;
        camGradY[0] = 0.0;
        camGradY[1] = 0.0;
        camGradY[2] = 0.0;
        camGradY[3] = 0.0;
        camGradY[4] = X / zz;
        camGradY[5] = Y / zz;
        camGradY[6] = Z / zz;
        camGradY[7] = W / zz;
        camGradY[8] = -X * yy / zz2;
        camGradY[9] = -Y * yy / zz2;
        camGradY[10] = -Z * yy / zz2;
        camGradY[11] = -W * yy / zz2;
    }

    private void addToJacobian(DMatrix tripplet, int col, int length, double[] a, double[] b) {
        for (int i = 0; i < length; ++i) {
            this.set(tripplet, this.jacRowX, col + i, a[i]);
            this.set(tripplet, this.jacRowY, col + i, b[i]);
        }
    }

    protected abstract void set(DMatrix var1, int var2, int var3, double var4);
}

