/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.PairLineNorm;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilPlane3D_F64;
import georegression.metric.Intersection3D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.plane.PlaneNormal3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class HomographyInducedStereo2Line {
    private Point3D_F64 e2 = new Point3D_F64();
    private DMatrixRMaj A = new DMatrixRMaj(3, 3);
    private DMatrixRMaj H = new DMatrixRMaj(3, 3);
    private AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    private Point3D_F64 Al0 = new Point3D_F64();
    private Point3D_F64 Al1 = new Point3D_F64();
    private Point3D_F64 v = new Point3D_F64();
    private DMatrixRMaj av = new DMatrixRMaj(3, 3);
    private PlaneGeneral3D_F64 planeA = new PlaneGeneral3D_F64();
    private PlaneGeneral3D_F64 planeB = new PlaneGeneral3D_F64();
    private LineParametric3D_F64 intersect0 = new LineParametric3D_F64();
    private LineParametric3D_F64 intersect1 = new LineParametric3D_F64();
    private PlaneNormal3D_F64 pi = new PlaneNormal3D_F64();
    private Vector3D_F64 from0to1 = new Vector3D_F64();
    private PlaneGeneral3D_F64 pi_gen = new PlaneGeneral3D_F64();

    public void setFundamental(DMatrixRMaj F, Point3D_F64 e2) {
        if (e2 != null) {
            this.e2.set(e2);
        } else {
            MultiViewOps.extractEpipoles(F, new Point3D_F64(), this.e2);
        }
        GeometryMath_F64.multCrossA((GeoTuple3D_F64)this.e2, (DMatrixRMaj)F, (DMatrixRMaj)this.A);
    }

    public boolean process(PairLineNorm line0, PairLineNorm line1) {
        double a0 = GeometryMath_F64.dot((GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)line0.l2);
        double a1 = GeometryMath_F64.dot((GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)line1.l2);
        GeometryMath_F64.multTran((DMatrixRMaj)this.A, (GeoTuple3D_F64)line0.l2, (GeoTuple3D_F64)this.Al0);
        GeometryMath_F64.multTran((DMatrixRMaj)this.A, (GeoTuple3D_F64)line1.l2, (GeoTuple3D_F64)this.Al1);
        this.planeA.set(line0.l1.x, line0.l1.y, line0.l1.z, 0.0);
        this.planeB.set(this.Al0.x, this.Al0.y, this.Al0.z, a0);
        if (!Intersection3D_F64.intersect((PlaneGeneral3D_F64)this.planeA, (PlaneGeneral3D_F64)this.planeB, (LineParametric3D_F64)this.intersect0)) {
            return false;
        }
        this.intersect0.slope.normalize();
        this.planeA.set(line1.l1.x, line1.l1.y, line1.l1.z, 0.0);
        this.planeB.set(this.Al1.x, this.Al1.y, this.Al1.z, a1);
        if (!Intersection3D_F64.intersect((PlaneGeneral3D_F64)this.planeA, (PlaneGeneral3D_F64)this.planeB, (LineParametric3D_F64)this.intersect1)) {
            return false;
        }
        this.intersect1.slope.normalize();
        this.from0to1.x = this.intersect1.p.x - this.intersect0.p.x;
        this.from0to1.y = this.intersect1.p.y - this.intersect0.p.y;
        this.from0to1.z = this.intersect1.p.z - this.intersect0.p.z;
        GeometryMath_F64.cross((GeoTuple3D_F64)this.intersect0.slope, (GeoTuple3D_F64)this.from0to1, (GeoTuple3D_F64)this.pi.n);
        this.pi.p.set(this.intersect0.p);
        UtilPlane3D_F64.convert((PlaneNormal3D_F64)this.pi, (PlaneGeneral3D_F64)this.pi_gen);
        this.v.set(this.pi_gen.A / this.pi_gen.D, this.pi_gen.B / this.pi_gen.D, this.pi_gen.C / this.pi_gen.D);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.v, (DMatrixRMaj)this.av);
        CommonOps_DDRM.subtract((DMatrixD1)this.A, (DMatrixD1)this.av, (DMatrixD1)this.H);
        this.adjust.adjust(this.H, line0);
        return true;
    }

    public DMatrixRMaj getHomography() {
        return this.H;
    }
}

