/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.alg.geo.bundle.cameras.BundlePinhole;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class SceneStructureCommon
implements SceneStructure {
    public FastQueue<Camera> cameras = new FastQueue(Camera.class, true);
    public final FastQueue<Point> points;
    public boolean homogenous;
    protected int pointSize;

    public SceneStructureCommon(boolean homogenous) {
        this.homogenous = homogenous;
        this.pointSize = homogenous ? 4 : 3;
        this.points = new FastQueue(Point.class, () -> new Point(this.pointSize));
    }

    public void setPoint(int which, double x, double y, double z) {
        ((Point[])this.points.data)[which].set(x, y, z);
    }

    public void setPoint(int which, double x, double y, double z, double w) {
        ((Point[])this.points.data)[which].set(x, y, z, w);
    }

    public void setCamera(int which, boolean fixed, BundleAdjustmentCamera model) {
        ((Camera)this.cameras.get((int)which)).known = fixed;
        ((Camera)this.cameras.get((int)which)).model = model;
    }

    public void setCamera(int which, boolean fixed, CameraPinhole intrinsic) {
        this.setCamera(which, fixed, new BundlePinhole(intrinsic));
    }

    public void setCamera(int which, boolean fixed, CameraPinholeBrown intrinsic) {
        this.setCamera(which, fixed, new BundlePinholeBrown(intrinsic));
    }

    public void connectPointToView(int pointIndex, int viewIndex) {
        Point p = ((Point[])this.points.data)[pointIndex];
        for (int i = 0; i < p.views.size; ++i) {
            if (p.views.data[i] != viewIndex) continue;
            throw new IllegalArgumentException("Tried to add the same view twice. viewIndex=" + viewIndex);
        }
        p.views.add(viewIndex);
    }

    public FastQueue<Point> getPoints() {
        return this.points;
    }

    public FastQueue<Camera> getCameras() {
        return this.cameras;
    }

    public int getUnknownCameraParameterCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.size; ++i) {
            if (((Camera[])this.cameras.data)[i].known) continue;
            total += ((Camera[])this.cameras.data)[i].model.getIntrinsicCount();
        }
        return total;
    }

    public void removePoints(GrowQueue_I32 which) {
        this.points.remove(which.data, 0, which.size, null);
    }

    @Override
    public boolean isHomogenous() {
        return this.homogenous;
    }

    public int getObservationCount() {
        int total = 0;
        for (int i = 0; i < this.points.size; ++i) {
            total += ((Point[])this.points.data)[i].views.size;
        }
        return total;
    }

    public static class Point {
        public double[] coordinate;
        public GrowQueue_I32 views = new GrowQueue_I32();

        public Point(int dof) {
            this.coordinate = new double[dof];
        }

        public void reset() {
            this.views.reset();
            this.coordinate[0] = Double.NaN;
        }

        public void removeView(int which) {
            int index = this.views.indexOf(which);
            if (index == -1) {
                throw new RuntimeException("BUG. Could not find in list of views. which=" + which);
            }
            this.views.remove(index);
        }

        public void set(double x, double y, double z) {
            this.coordinate[0] = x;
            this.coordinate[1] = y;
            this.coordinate[2] = z;
        }

        public void set(double x, double y, double z, double w) {
            this.coordinate[0] = x;
            this.coordinate[1] = y;
            this.coordinate[2] = z;
            this.coordinate[3] = w;
        }

        public void get(Point3D_F64 p) {
            p.x = this.coordinate[0];
            p.y = this.coordinate[1];
            p.z = this.coordinate[2];
        }

        public void get(Point4D_F64 p) {
            p.x = this.coordinate[0];
            p.y = this.coordinate[1];
            p.z = this.coordinate[2];
            p.w = this.coordinate[3];
        }

        public double getX() {
            return this.coordinate[0];
        }

        public double getY() {
            return this.coordinate[1];
        }

        public double getZ() {
            return this.coordinate[2];
        }

        public double getW() {
            return this.coordinate[3];
        }

        public double distanceSq(Point3D_F64 p) {
            double dx = this.coordinate[0] - p.x;
            double dy = this.coordinate[1] - p.y;
            double dz = this.coordinate[2] - p.z;
            return dx * dx + dy * dy + dz * dz;
        }

        public void normalizeH() {
            double n = 0.0;
            n += this.coordinate[0] * this.coordinate[0];
            n += this.coordinate[1] * this.coordinate[1];
            n += this.coordinate[2] * this.coordinate[2];
            n += this.coordinate[3] * this.coordinate[3];
            n = Math.sqrt(n);
            this.coordinate[0] = this.coordinate[0] / n;
            this.coordinate[1] = this.coordinate[1] / n;
            this.coordinate[2] = this.coordinate[2] / n;
            this.coordinate[3] = this.coordinate[3] / n;
        }

        public double distance(Point3D_F64 p) {
            return Math.sqrt(this.distance(p));
        }

        public double distance(Point p) {
            double dx = this.coordinate[0] - p.coordinate[0];
            double dy = this.coordinate[1] - p.coordinate[1];
            double dz = this.coordinate[2] - p.coordinate[2];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
    }

    public static class Camera {
        public boolean known = true;
        public BundleAdjustmentCamera model;

        public <T extends BundleAdjustmentCamera> T getModel() {
            return (T)this.model;
        }

        public void reset() {
            this.known = true;
            this.model = null;
        }
    }
}

