/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.alg.geo.impl.ImplPerspectiveOps_F32;
import boofcv.alg.geo.impl.ImplPerspectiveOps_F64;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.geometry.UtilVector3D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import javax.annotation.Nullable;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class PerspectiveOps {
    public static CameraPinhole approximatePinhole(Point2Transform2_F64 p2n, int width, int height) {
        Point2D_F64 na = new Point2D_F64();
        Point2D_F64 nb = new Point2D_F64();
        p2n.compute(0.0, (double)(height / 2), na);
        p2n.compute((double)(width - 1), (double)(height / 2), nb);
        double abdot = na.x * nb.x + na.y * nb.y + 1.0;
        double normA = Math.sqrt(na.x * na.x + na.y * na.y + 1.0);
        double normB = Math.sqrt(nb.x * nb.x + nb.y * nb.y + 1.0);
        double hfov = Math.acos(abdot / (normA * normB));
        p2n.compute((double)(width / 2), 0.0, na);
        p2n.compute((double)(width / 2), (double)(height - 1), nb);
        abdot = na.x * nb.x + na.y * nb.y + 1.0;
        normA = Math.sqrt(na.x * na.x + na.y * na.y + 1.0);
        normB = Math.sqrt(nb.x * nb.x + nb.y * nb.y + 1.0);
        double vfov = Math.acos(abdot / (normA * normB));
        return PerspectiveOps.createIntrinsic(width, height, UtilAngle.degree((double)hfov), UtilAngle.degree((double)vfov));
    }

    public static CameraPinhole createIntrinsic(int width, int height, double hfov, double vfov) {
        CameraPinhole intrinsic = new CameraPinhole();
        intrinsic.width = width;
        intrinsic.height = height;
        intrinsic.cx = width / 2;
        intrinsic.cy = height / 2;
        intrinsic.fx = intrinsic.cx / Math.tan(UtilAngle.degreeToRadian((double)(hfov / 2.0)));
        intrinsic.fy = intrinsic.cy / Math.tan(UtilAngle.degreeToRadian((double)(vfov / 2.0)));
        return intrinsic;
    }

    public static CameraPinholeBrown createIntrinsic(int width, int height, double hfov) {
        CameraPinholeBrown intrinsic = new CameraPinholeBrown();
        intrinsic.width = width;
        intrinsic.height = height;
        intrinsic.cx = width / 2;
        intrinsic.cy = height / 2;
        intrinsic.fy = intrinsic.fx = intrinsic.cx / Math.tan(UtilAngle.degreeToRadian((double)(hfov / 2.0)));
        return intrinsic;
    }

    public static void scaleIntrinsic(CameraPinhole param, double scale) {
        param.width = (int)((double)param.width * scale);
        param.height = (int)((double)param.height * scale);
        param.cx *= scale;
        param.cy *= scale;
        param.fx *= scale;
        param.fy *= scale;
        param.skew *= scale;
    }

    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, DMatrixRMaj adjustMatrix, C adjustedParam) {
        return ImplPerspectiveOps_F64.adjustIntrinsic(parameters, adjustMatrix, adjustedParam);
    }

    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, FMatrixRMaj adjustMatrix, C adjustedParam) {
        return ImplPerspectiveOps_F32.adjustIntrinsic(parameters, adjustMatrix, adjustedParam);
    }

    public static DMatrixRMaj pinholeToMatrix(double fx, double fy, double skew, double cx, double cy) {
        return ImplPerspectiveOps_F64.pinholeToMatrix(fx, fy, skew, cx, cy, null);
    }

    public static void pinholeToMatrix(double fx, double fy, double skew, double cx, double cy, DMatrix3x3 K) {
        K.a11 = fx;
        K.a12 = skew;
        K.a13 = cx;
        K.a22 = fy;
        K.a23 = cy;
        K.a33 = 1.0;
        K.a32 = 0.0;
        K.a31 = 0.0;
        K.a21 = 0.0;
    }

    public static void invertPinhole(DMatrix3x3 K, DMatrix3x3 Kinv) {
        double fx = K.a11;
        double skew = K.a12;
        double cx = K.a13;
        double fy = K.a22;
        double cy = K.a23;
        Kinv.a11 = 1.0 / fx;
        Kinv.a12 = -skew / (fx * fy);
        Kinv.a13 = (skew * cy - cx * fy) / (fx * fy);
        Kinv.a22 = 1.0 / fy;
        Kinv.a23 = -cy / fy;
        Kinv.a33 = 1.0;
    }

    public static FMatrixRMaj pinholeToMatrix(float fx, float fy, float skew, float xc, float yc) {
        return ImplPerspectiveOps_F32.pinholeToMatrix(fx, fy, skew, xc, yc, null);
    }

    public static DMatrixRMaj pinholeToMatrix(CameraPinhole param, DMatrixRMaj K) {
        return ImplPerspectiveOps_F64.pinholeToMatrix(param, K);
    }

    public static FMatrixRMaj pinholeToMatrix(CameraPinhole param, FMatrixRMaj K) {
        return ImplPerspectiveOps_F32.pinholeToMatrix(param, K);
    }

    public static DMatrix3x3 pinholeToMatrix(CameraPinhole param, DMatrix3x3 K) {
        return ImplPerspectiveOps_F64.pinholeToMatrix(param, K);
    }

    public static <C extends CameraPinhole> C matrixToPinhole(DMatrixRMaj K, int width, int height, C output) {
        return (C)ImplPerspectiveOps_F64.matrixToPinhole(K, width, height, output);
    }

    public static <C extends CameraPinhole> C matrixToPinhole(FMatrixRMaj K, int width, int height, C output) {
        return (C)ImplPerspectiveOps_F32.matrixToPinhole(K, width, height, output);
    }

    public static CameraPinhole estimatePinhole(Point2Transform2_F64 pixelToNorm, int width, int height) {
        Point2D_F64 normA = new Point2D_F64();
        Point2D_F64 normB = new Point2D_F64();
        Vector3D_F64 vectorA = new Vector3D_F64();
        Vector3D_F64 vectorB = new Vector3D_F64();
        pixelToNorm.compute(0.0, (double)(height / 2), normA);
        pixelToNorm.compute((double)width, (double)(height / 2), normB);
        vectorA.set(normA.x, normA.y, 1.0);
        vectorB.set(normB.x, normB.y, 1.0);
        double hfov = UtilVector3D_F64.acute((GeoTuple3D_F64)vectorA, (GeoTuple3D_F64)vectorB);
        pixelToNorm.compute((double)(width / 2), 0.0, normA);
        pixelToNorm.compute((double)(width / 2), (double)height, normB);
        vectorA.set(normA.x, normA.y, 1.0);
        vectorB.set(normB.x, normB.y, 1.0);
        double vfov = UtilVector3D_F64.acute((GeoTuple3D_F64)vectorA, (GeoTuple3D_F64)vectorB);
        CameraPinhole intrinsic = new CameraPinhole();
        intrinsic.width = width;
        intrinsic.height = height;
        intrinsic.skew = 0.0;
        intrinsic.cx = width / 2;
        intrinsic.cy = height / 2;
        intrinsic.fx = intrinsic.cx / Math.tan(hfov / 2.0);
        intrinsic.fy = intrinsic.cy / Math.tan(vfov / 2.0);
        return intrinsic;
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, double x, double y, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.convertNormToPixel(param, x, y, pixel);
    }

    public static Point2D_F64 convertNormToPixel(CameraPinhole param, double x, double y, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        pixel.x = param.fx * x + param.skew * y + param.cx;
        pixel.y = param.fy * y + param.cy;
        return pixel;
    }

    public static Point2D_F32 convertNormToPixel(CameraModel param, float x, float y, Point2D_F32 pixel) {
        return ImplPerspectiveOps_F32.convertNormToPixel(param, x, y, pixel);
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, Point2D_F64 norm, Point2D_F64 pixel) {
        return PerspectiveOps.convertNormToPixel(param, norm.x, norm.y, pixel);
    }

    public static Point2D_F64 convertNormToPixel(DMatrixRMaj K, Point2D_F64 norm, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.convertNormToPixel(K, norm, pixel);
    }

    public static Point2D_F64 convertPixelToNorm(CameraModel param, Point2D_F64 pixel, Point2D_F64 norm) {
        return ImplPerspectiveOps_F64.convertPixelToNorm(param, pixel, norm);
    }

    public static Point2D_F32 convertPixelToNorm(CameraModel param, Point2D_F32 pixel, Point2D_F32 norm) {
        return ImplPerspectiveOps_F32.convertPixelToNorm(param, pixel, norm);
    }

    public static Point2D_F64 convertPixelToNorm(DMatrixRMaj K, Point2D_F64 pixel, Point2D_F64 norm) {
        return ImplPerspectiveOps_F64.convertPixelToNorm(K, pixel, norm);
    }

    public static Point2D_F32 convertPixelToNorm(FMatrixRMaj K, Point2D_F32 pixel, Point2D_F32 norm) {
        return ImplPerspectiveOps_F32.convertPixelToNorm(K, pixel, norm);
    }

    public static Point2D_F64 convertPixelToNorm(CameraPinhole intrinsic, double x, double y, Point2D_F64 norm) {
        return ImplPerspectiveOps_F64.convertPixelToNorm(intrinsic, x, y, norm);
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, DMatrixRMaj K, Point3D_F64 X, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.renderPixel(worldToCamera, K, X, pixel);
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, CameraPinhole K, Point3D_F64 X, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.renderPixel(worldToCamera, K.fy, K.skew, K.cx, K.fy, K.cy, X, pixel);
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, Point3D_F64 X, Point2D_F64 pixel) {
        return ImplPerspectiveOps_F64.renderPixel(worldToCamera, 1.0, 0.0, 0.0, 1.0, 0.0, X, pixel);
    }

    public static Point2D_F64 renderPixel(CameraPinhole intrinsic, Point3D_F64 X, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        pixel.set(X.x / X.z, X.y / X.z);
        return PerspectiveOps.convertNormToPixel(intrinsic, pixel, pixel);
    }

    public static Point2D_F64 renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X) {
        return PerspectiveOps.renderPixel(worldToCamera, X, (Point2D_F64)null);
    }

    public static Point2D_F64 renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X, @Nullable Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        ImplPerspectiveOps_F64.renderPixel(worldToCamera, X, pixel);
        return pixel;
    }

    public static Point3D_F64 renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X, @Nullable Point3D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point3D_F64();
        }
        ImplPerspectiveOps_F64.renderPixel(worldToCamera, X, pixel);
        return pixel;
    }

    public static Point3D_F64 renderPixel(DMatrixRMaj cameraMatrix, Point4D_F64 X, @Nullable Point3D_F64 x) {
        if (x == null) {
            x = new Point3D_F64();
        }
        ImplPerspectiveOps_F64.renderPixel(cameraMatrix, X, x);
        return x;
    }

    public static Point2D_F64 renderPixel(DMatrixRMaj cameraMatrix, Point4D_F64 X, @Nullable Point2D_F64 x) {
        if (x == null) {
            x = new Point2D_F64();
        }
        ImplPerspectiveOps_F64.renderPixel(cameraMatrix, X, x);
        return x;
    }

    public static void splitAssociated(List<AssociatedPair> pairs, List<Point2D_F64> view1, List<Point2D_F64> view2) {
        for (AssociatedPair p : pairs) {
            view1.add(p.p1);
            view2.add(p.p2);
        }
    }

    public static void splitAssociated(List<AssociatedTriple> pairs, List<Point2D_F64> view1, List<Point2D_F64> view2, List<Point2D_F64> view3) {
        for (AssociatedTriple p : pairs) {
            view1.add(p.p1);
            view2.add(p.p2);
            view3.add(p.p3);
        }
    }

    public static DMatrixRMaj createCameraMatrix(DMatrixRMaj R, Vector3D_F64 T, @Nullable DMatrixRMaj K, @Nullable DMatrixRMaj ret) {
        return ImplPerspectiveOps_F64.createCameraMatrix(R, T, K, ret);
    }

    public static void projectionSplit(DMatrixRMaj P, DMatrixRMaj M, Vector3D_F64 T) {
        CommonOps_DDRM.extract((DMatrix)P, (int)0, (int)3, (int)0, (int)3, (DMatrix)M, (int)0, (int)0);
        T.x = P.get(0, 3);
        T.y = P.get(1, 3);
        T.z = P.get(2, 3);
    }

    public static void projectionSplit(DMatrixRMaj P, DMatrix3x3 M, DMatrix3 T) {
        M.a11 = P.data[0];
        M.a12 = P.data[1];
        M.a13 = P.data[2];
        T.a1 = P.data[3];
        M.a21 = P.data[4];
        M.a22 = P.data[5];
        M.a23 = P.data[6];
        T.a2 = P.data[7];
        M.a31 = P.data[8];
        M.a32 = P.data[9];
        M.a33 = P.data[10];
        T.a3 = P.data[11];
    }

    public static void projectionCombine(DMatrixRMaj M, Vector3D_F64 T, DMatrixRMaj P) {
        CommonOps_DDRM.insert((DMatrix)M, (DMatrix)P, (int)0, (int)0);
        P.data[3] = T.x;
        P.data[7] = T.y;
        P.data[11] = T.z;
    }

    public static WorldToCameraToPixel createWorldToPixel(CameraPinholeBrown intrinsic, Se3_F64 worldToCamera) {
        WorldToCameraToPixel alg = new WorldToCameraToPixel();
        alg.configure(intrinsic, worldToCamera);
        return alg;
    }

    public static WorldToCameraToPixel createWorldToPixel(LensDistortionNarrowFOV distortion, Se3_F64 worldToCamera) {
        WorldToCameraToPixel alg = new WorldToCameraToPixel();
        alg.configure(distortion, worldToCamera);
        return alg;
    }

    public static double computeHFov(CameraPinhole intrinsic) {
        return 2.0 * Math.atan((double)(intrinsic.width / 2) / intrinsic.fx);
    }

    public static double computeVFov(CameraPinhole intrinsic) {
        return 2.0 * Math.atan((double)(intrinsic.height / 2) / intrinsic.fy);
    }

    public static double crossRatios(Point3D_F64 a0, Point3D_F64 a1, Point3D_F64 a2, Point3D_F64 a3) {
        double d01 = a0.distance((GeoTuple_F64)a1);
        double d23 = a2.distance((GeoTuple_F64)a3);
        double d02 = a0.distance((GeoTuple_F64)a2);
        double d13 = a1.distance((GeoTuple_F64)a3);
        return d01 * d23 / (d02 * d13);
    }

    public static double crossRatios(Point2D_F64 a0, Point2D_F64 a1, Point2D_F64 a2, Point2D_F64 a3) {
        double d01 = a0.distance((GeoTuple2D_F64)a1);
        double d23 = a2.distance((GeoTuple2D_F64)a3);
        double d02 = a0.distance((GeoTuple2D_F64)a2);
        double d13 = a1.distance((GeoTuple2D_F64)a3);
        return d01 * d23 / (d02 * d13);
    }

    public static DMatrixRMaj convertToMatrix(Se3_F64 m, DMatrixRMaj A) {
        if (A == null) {
            A = new DMatrixRMaj(3, 4);
        } else {
            A.reshape(3, 4);
        }
        CommonOps_DDRM.insert((DMatrix)m.R, (DMatrix)A, (int)0, (int)0);
        A.data[3] = m.T.x;
        A.data[7] = m.T.y;
        A.data[11] = m.T.z;
        return A;
    }

    public static void extractColumn(DMatrixRMaj P, int col, GeoTuple3D_F64 a) {
        a.x = P.unsafe_get(0, col);
        a.y = P.unsafe_get(1, col);
        a.z = P.unsafe_get(2, col);
    }

    public static void insertColumn(DMatrixRMaj P, int col, GeoTuple3D_F64 a) {
        P.unsafe_set(0, col, a.x);
        P.unsafe_set(1, col, a.y);
        P.unsafe_set(2, col, a.z);
    }

    public static void multTranA(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C, DMatrixRMaj output) {
        double t11 = A.data[0] * B.data[0] + A.data[3] * B.data[3] + A.data[6] * B.data[6];
        double t12 = A.data[0] * B.data[1] + A.data[3] * B.data[4] + A.data[6] * B.data[7];
        double t13 = A.data[0] * B.data[2] + A.data[3] * B.data[5] + A.data[6] * B.data[8];
        double t21 = A.data[1] * B.data[0] + A.data[4] * B.data[3] + A.data[7] * B.data[6];
        double t22 = A.data[1] * B.data[1] + A.data[4] * B.data[4] + A.data[7] * B.data[7];
        double t23 = A.data[1] * B.data[2] + A.data[4] * B.data[5] + A.data[7] * B.data[8];
        double t31 = A.data[2] * B.data[0] + A.data[5] * B.data[3] + A.data[8] * B.data[6];
        double t32 = A.data[2] * B.data[1] + A.data[5] * B.data[4] + A.data[8] * B.data[7];
        double t33 = A.data[2] * B.data[2] + A.data[5] * B.data[5] + A.data[8] * B.data[8];
        output.data[0] = t11 * C.data[0] + t12 * C.data[3] + t13 * C.data[6];
        output.data[1] = t11 * C.data[1] + t12 * C.data[4] + t13 * C.data[7];
        output.data[2] = t11 * C.data[2] + t12 * C.data[5] + t13 * C.data[8];
        output.data[3] = t21 * C.data[0] + t22 * C.data[3] + t23 * C.data[6];
        output.data[4] = t21 * C.data[1] + t22 * C.data[4] + t23 * C.data[7];
        output.data[5] = t21 * C.data[2] + t22 * C.data[5] + t23 * C.data[8];
        output.data[6] = t31 * C.data[0] + t32 * C.data[3] + t33 * C.data[6];
        output.data[7] = t31 * C.data[1] + t32 * C.data[4] + t33 * C.data[7];
        output.data[8] = t31 * C.data[2] + t32 * C.data[5] + t33 * C.data[8];
    }

    public static void multTranC(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C, DMatrixRMaj output) {
        double t11 = A.data[0] * B.data[0] + A.data[1] * B.data[3] + A.data[2] * B.data[6];
        double t12 = A.data[0] * B.data[1] + A.data[1] * B.data[4] + A.data[2] * B.data[7];
        double t13 = A.data[0] * B.data[2] + A.data[1] * B.data[5] + A.data[2] * B.data[8];
        double t21 = A.data[3] * B.data[0] + A.data[4] * B.data[3] + A.data[5] * B.data[6];
        double t22 = A.data[3] * B.data[1] + A.data[4] * B.data[4] + A.data[5] * B.data[7];
        double t23 = A.data[3] * B.data[2] + A.data[4] * B.data[5] + A.data[5] * B.data[8];
        double t31 = A.data[6] * B.data[0] + A.data[7] * B.data[3] + A.data[8] * B.data[6];
        double t32 = A.data[6] * B.data[1] + A.data[7] * B.data[4] + A.data[8] * B.data[7];
        double t33 = A.data[6] * B.data[2] + A.data[7] * B.data[5] + A.data[8] * B.data[8];
        output.data[0] = t11 * C.data[0] + t12 * C.data[1] + t13 * C.data[2];
        output.data[1] = t11 * C.data[3] + t12 * C.data[4] + t13 * C.data[5];
        output.data[2] = t11 * C.data[6] + t12 * C.data[7] + t13 * C.data[8];
        output.data[3] = t21 * C.data[0] + t22 * C.data[1] + t23 * C.data[2];
        output.data[4] = t21 * C.data[3] + t22 * C.data[4] + t23 * C.data[5];
        output.data[5] = t21 * C.data[6] + t22 * C.data[7] + t23 * C.data[8];
        output.data[6] = t31 * C.data[0] + t32 * C.data[1] + t33 * C.data[2];
        output.data[7] = t31 * C.data[3] + t32 * C.data[4] + t33 * C.data[5];
        output.data[8] = t31 * C.data[6] + t32 * C.data[7] + t33 * C.data[8];
    }

    public static void multTranA(DMatrix3x3 A, DMatrix3x3 B, DMatrix3x3 C, DMatrix3x3 output) {
        double t11 = A.a11 * B.a11 + A.a21 * B.a21 + A.a31 * B.a31;
        double t12 = A.a11 * B.a12 + A.a21 * B.a22 + A.a31 * B.a32;
        double t13 = A.a11 * B.a13 + A.a21 * B.a23 + A.a31 * B.a33;
        double t21 = A.a12 * B.a11 + A.a22 * B.a21 + A.a32 * B.a31;
        double t22 = A.a12 * B.a12 + A.a22 * B.a22 + A.a32 * B.a32;
        double t23 = A.a12 * B.a13 + A.a22 * B.a23 + A.a32 * B.a33;
        double t31 = A.a13 * B.a11 + A.a23 * B.a21 + A.a33 * B.a31;
        double t32 = A.a13 * B.a12 + A.a23 * B.a22 + A.a33 * B.a32;
        double t33 = A.a13 * B.a13 + A.a23 * B.a23 + A.a33 * B.a33;
        output.a11 = t11 * C.a11 + t12 * C.a21 + t13 * C.a31;
        output.a12 = t11 * C.a12 + t12 * C.a22 + t13 * C.a32;
        output.a13 = t11 * C.a13 + t12 * C.a23 + t13 * C.a33;
        output.a21 = t21 * C.a11 + t22 * C.a21 + t23 * C.a31;
        output.a22 = t21 * C.a12 + t22 * C.a22 + t23 * C.a32;
        output.a23 = t21 * C.a13 + t22 * C.a23 + t23 * C.a33;
        output.a31 = t31 * C.a11 + t32 * C.a21 + t33 * C.a31;
        output.a32 = t31 * C.a12 + t32 * C.a22 + t33 * C.a32;
        output.a33 = t31 * C.a13 + t32 * C.a23 + t33 * C.a33;
    }

    public static void multTranC(DMatrix3x3 A, DMatrix3x3 B, DMatrix3x3 C, DMatrix3x3 output) {
        double t11 = A.a11 * B.a11 + A.a12 * B.a21 + A.a13 * B.a31;
        double t12 = A.a11 * B.a12 + A.a12 * B.a22 + A.a13 * B.a32;
        double t13 = A.a11 * B.a13 + A.a12 * B.a23 + A.a13 * B.a33;
        double t21 = A.a21 * B.a11 + A.a22 * B.a21 + A.a23 * B.a31;
        double t22 = A.a21 * B.a12 + A.a22 * B.a22 + A.a23 * B.a32;
        double t23 = A.a21 * B.a13 + A.a22 * B.a23 + A.a23 * B.a33;
        double t31 = A.a31 * B.a11 + A.a32 * B.a21 + A.a33 * B.a31;
        double t32 = A.a31 * B.a12 + A.a32 * B.a22 + A.a33 * B.a32;
        double t33 = A.a31 * B.a13 + A.a32 * B.a23 + A.a33 * B.a33;
        output.a11 = t11 * C.a11 + t12 * C.a12 + t13 * C.a13;
        output.a12 = t11 * C.a21 + t12 * C.a22 + t13 * C.a23;
        output.a13 = t11 * C.a31 + t12 * C.a32 + t13 * C.a33;
        output.a21 = t21 * C.a11 + t22 * C.a12 + t23 * C.a13;
        output.a22 = t21 * C.a21 + t22 * C.a22 + t23 * C.a23;
        output.a23 = t21 * C.a31 + t22 * C.a32 + t23 * C.a33;
        output.a31 = t31 * C.a11 + t32 * C.a12 + t33 * C.a13;
        output.a32 = t31 * C.a21 + t32 * C.a22 + t33 * C.a23;
        output.a33 = t31 * C.a31 + t32 * C.a32 + t33 * C.a33;
    }

    public static void inplaceAdjustCameraMatrix(double sx, double sy, double tx, double ty, DMatrixRMaj P) {
        int col = 0;
        while (col < 4) {
            int row0 = col++;
            int row1 = 4 + row0;
            int row2 = 4 + row1;
            P.data[row0] = P.data[row0] * sx + tx * P.data[row2];
            P.data[row1] = P.data[row1] * sy + ty * P.data[row2];
        }
    }
}

